/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double BIKE_SADDLE_X = 300.0;
    private static final double BIKE_SADDLE_Y = 100.0;
    private static final double HANDLE_RADIUS = 10.0;
    private static final double FRAME_LENGTH = 220.0;
    private static final double WHEEL_RADIUS = 80.0;
    private static final double BACK_WHEEL_CENTER_X = 200.0;
    private static final double FRONT_WHEEL_CENTER_X = 600.0;
    private static final double WHEEL_CENTER_Y = 300.0;
    private static final double PEDAL_CENTER_X = 380.0;
    private static final double PEDAL_RADIUS = 25.0;
    private static final double FRAME_POSITION_X = 318.0;
    private static final double FRAME_POSITION_Y = 145.0;

    public void run() {
        this.drawBike();
        this.addSignature();
    }

    private void addSignature() {
        GLabel gLabel = new GLabel("Artistry by Ruoxing Liu  ");
        gLabel.setFont("Arial-20");
        gLabel.setColor(Color.BLUE);
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getAscent();
        this.add((GObject)gLabel, d, d2);
    }

    private void drawBike() {
        this.addSaddle(300.0, 100.0);
        this.addFrontSet(520.0, 100.0, 10.0);
        this.addWheel(200.0, 300.0, 80.0);
        this.addWheel(600.0, 300.0, 80.0);
        this.addPedal(380.0, 300.0, 25.0);
        this.addFrame();
    }

    private void addSaddle(double d, double d2) {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(d, d2);
        gPolygon.addVertex(d + 40.0, d2 - 25.0);
        gPolygon.addVertex(d - 30.0, d2 - 25.0);
        gPolygon.setFilled(true);
        gPolygon.setColor(new Color(20, 40, 255));
        this.add((GObject)gPolygon);
    }

    private void addFrontSet(double d, double d2, double d3) {
        GOval gOval = new GOval(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
        gOval.setFilled(true);
        gOval.setColor(Color.BLACK);
        this.add((GObject)gOval);
    }

    private void addWheel(double d, double d2, double d3) {
        GOval gOval = new GOval(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
        gOval.setFilled(true);
        gOval.setColor(Color.darkGray);
        this.add((GObject)gOval);
        GOval gOval2 = new GOval(d - d3 / 1.1, d2 - d3 / 1.1, 2.0 * d3 / 1.1, 2.0 * d3 / 1.1);
        gOval2.setFilled(true);
        gOval2.setColor(Color.WHITE);
        this.add((GObject)gOval2);
        GOval gOval3 = new GOval(d - 5.0, d2 - 5.0, 10.0, 10.0);
        gOval3.setFilled(true);
        gOval3.setColor(Color.BLACK);
        this.add((GObject)gOval3);
        for (double d4 = 0.0; d4 <= 18.0; d4 += 1.0) {
            double d5 = 0.3490658503988659 * d4;
            GLine gLine = new GLine(d, d2, d + d3 * Math.cos(d5), d2 + d3 * Math.sin(d5));
            gLine.setColor(Color.darkGray);
            this.add((GObject)gLine);
        }
    }

    private void addPedal(double d, double d2, double d3) {
        GOval gOval = new GOval(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
        this.add((GObject)gOval);
    }

    private void addFrame() {
        GLine gLine = new GLine(300.0, 100.0, 380.0, 300.0);
        GLine gLine2 = new GLine(380.0, 300.0, 200.0, 300.0);
        GLine gLine3 = new GLine(380.0, 275.0, 200.0, 295.0);
        GLine gLine4 = new GLine(380.0, 325.0, 200.0, 305.0);
        GLine gLine5 = new GLine(520.0, 100.0, 600.0, 300.0);
        GLine gLine6 = new GLine(200.0, 300.0, 318.0, 145.0);
        GLine gLine7 = new GLine(318.0, 145.0, 538.0, 145.0);
        GLine gLine8 = new GLine(380.0, 300.0, 538.0, 145.0);
        this.add((GObject)gLine);
        this.add((GObject)gLine2);
        this.add((GObject)gLine3);
        this.add((GObject)gLine4);
        this.add((GObject)gLine5);
        this.add((GObject)gLine6);
        this.add((GObject)gLine7);
        this.add((GObject)gLine8);
    }
}

