/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    public static final int APPLICATION_WIDTH = 500;
    public static final int APPLICATION_HEIGHT = 450;
    private static final double CAN_HEIGHT = 140.0;
    private static final double CAN_WIDTH = 100.0;
    private static final double SEAL_RADIUS = 13.0;
    private static final double LID_THICKNESS = 20.0;
    private static final double LOGO_OFFSET = 43.0;
    private static final double SUBLOGO_OFFSET = 63.0;
    private static final double HOR_MARGIN = 50.0;
    private static final double VER_MARGIN = 50.0;
    private static final double CAN_SPACE = 50.0;
    private static final String[] FLAVORS = new String[]{"TOMATO", "VEGETABLE", "GREEN PEA", "BEEF", "CHICKEN", "ONION"};
    private static final double BOTTOM_OFFSET = 5.0;
    private static final double LEFT_OVAL_TRIM = 1.0;
    private static final double OVAL_WIDTH_TRIM = 4.0;
    private static final String AUTHOR = "Stephen Koo";
    private static final double SIG_MARGIN = 5.0;

    public void run() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < FLAVORS.length; ++i) {
            double d = this.calcCanX(n);
            double d2 = this.calcCanY(n2);
            this.drawCan(FLAVORS[i], d, d2);
            if (this.calcCanX(n + 1) + 100.0 > 450.0) {
                ++n2;
                n = 0;
                continue;
            }
            ++n;
        }
        this.signName(AUTHOR);
    }

    private double calcCanX(int n) {
        double d = 50.0 + (double)n * 150.0;
        return d;
    }

    private double calcCanY(int n) {
        double d = 50.0 + (double)n * 190.0;
        return d;
    }

    private void drawCan(String string, double d, double d2) {
        double d3 = d + 50.0;
        double d4 = d2 + 70.0;
        GRect gRect = new GRect(d, d2, 100.0, 70.0);
        gRect.setColor(Color.RED);
        gRect.setFilled(true);
        GRect gRect2 = new GRect(d, d4, 100.0, 70.0);
        gRect2.setColor(Color.WHITE);
        gRect2.setFilled(true);
        GRect gRect3 = new GRect(d, d2, 100.0, 140.0);
        this.add((GObject)gRect);
        this.add((GObject)gRect2);
        this.add((GObject)gRect3);
        GOval gOval = this.newTrimOval(d, d2 - 10.0, 100.0, 20.0, Color.GRAY, true);
        GOval gOval2 = this.newTrimOval(d, d2 + 140.0 - 10.0, 100.0, 20.0, Color.GRAY, true);
        GOval gOval3 = this.newTrimOval(d, d2 + 140.0 - 10.0 - 5.0, 100.0, 20.0, Color.WHITE, true);
        GOval gOval4 = this.newTrimOval(d, d2 + 60.0, 100.0, 20.0, Color.RED, true);
        this.add((GObject)gOval);
        this.add((GObject)gOval2);
        this.add((GObject)gOval3);
        this.add((GObject)gOval4);
        double d5 = d3 - 13.0;
        double d6 = d2 + 80.0 - 13.0;
        GOval gOval5 = new GOval(d5, d6, 26.0, 26.0);
        gOval5.setColor(new Color(184, 134, 11));
        gOval5.setFilled(true);
        this.add((GObject)gOval5);
        GLabel gLabel = this.newCenteredLabel("Campbell's", d3, d2 + 43.0, "Serif-bold-18", Color.WHITE);
        GLabel gLabel2 = this.newCenteredLabel("Condensed", d3, d2 + 63.0, "SansSerif", Color.WHITE);
        GLabel gLabel3 = this.newCenteredLabel(string, d3, d4 + 43.0, "SansSerif-bold-16", Color.RED);
        GLabel gLabel4 = this.newCenteredLabel("SOUP", d3, d4 + 63.0, "SansSerif-bold-16", Color.BLACK);
        this.add((GObject)gLabel);
        this.add((GObject)gLabel2);
        this.add((GObject)gLabel3);
        this.add((GObject)gLabel4);
    }

    private void signName(String string) {
        GLabel gLabel = new GLabel("Artistry by " + string);
        double d = 500.0 - gLabel.getWidth() - 5.0;
        double d2 = 445.0;
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }

    private GOval newTrimOval(double d, double d2, double d3, double d4, Color color, boolean bl) {
        GOval gOval = new GOval(d + 1.0, d2, d3 - 4.0, d4);
        gOval.setColor(color);
        gOval.setFilled(bl);
        return gOval;
    }

    private GLabel newCenteredLabel(String string, double d, double d2, String string2, Color color) {
        GLabel gLabel = new GLabel(string);
        gLabel.setFont(string2);
        double d3 = d - gLabel.getWidth() / 2.0;
        double d4 = d2;
        gLabel.setLocation(d3, d4);
        gLabel.setColor(color);
        return gLabel;
    }
}

