/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GMath;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double DISK_SIZE = 0.14285714285714285;
    private static final double PETAL_SIZE = 0.07142857142857142;
    private static final double COS45 = GMath.cosDegrees((double)45.0);
    private static final double SIN45 = GMath.sinDegrees((double)45.0);
    private static final double TAN60 = GMath.tanDegrees((double)60.0);
    private static final double DISK_POSITION = 0.2857142857142857;
    private static final double STEM_POINT1_POSITION = 0.25;
    private static final double STEM_POINT2_POSITION = 0.5;
    private static final double STEM_POINT3_POSITION = 0.625;
    private static final double STEM_POINT4_POSITION = 0.8;
    private static final double LEAVES_POINT1_POSITIONX = 0.5;
    private static final double LEAVES_POINT1_POSITIONY = 0.1;
    private static final double LEAVES_POINT2_POSITIONX = 1.0;
    private static final double LEAVES_POINT2_POSITIONY = 0.6;

    public void run() {
        double d = (double)this.getHeight() * 0.14285714285714285;
        double d2 = (double)this.getWidth() / 2.0;
        double d3 = (double)this.getHeight() * 0.2857142857142857;
        double d4 = d2;
        double d5 = d3 - d;
        double d6 = d2 + d;
        double d7 = d3;
        double d8 = d2;
        double d9 = d3 + d;
        double d10 = d2 - d;
        double d11 = d3;
        double d12 = d2 + d * COS45;
        double d13 = d3 - d * SIN45;
        double d14 = d12;
        double d15 = d3 + d * SIN45;
        double d16 = d2 - d * COS45;
        double d17 = d15;
        double d18 = d16;
        double d19 = d13;
        double d20 = d6;
        double d21 = d9 + 2.0 * d * TAN60;
        this.drawStemAndLeaves(d8, d9, d20, d21);
        this.drawPetal(d4, d5);
        this.drawPetal(d6, d7);
        this.drawPetal(d8, d9);
        this.drawPetal(d10, d11);
        this.drawPetal(d12, d13);
        this.drawPetal(d14, d15);
        this.drawPetal(d16, d17);
        this.drawPetal(d18, d19);
        this.drawCircle(d2, d3, d, Color.ORANGE, Color.YELLOW);
        this.drawLine(d4, d5, d14, d15, Color.BLACK);
        this.drawLine(d18, d19, d8, d9, Color.BLACK);
        this.drawLine(d10, d11, d12, d13, Color.BLACK);
        this.drawLine(d6, d7, d16, d17, Color.BLACK);
        this.title();
        this.signName();
    }

    private void drawCircle(double d, double d2, double d3, Color color, Color color2) {
        GOval gOval = new GOval(d - d3, d2 - d3, 2.0 * d3, 2.0 * d3);
        gOval.setColor(color);
        gOval.setFilled(true);
        gOval.setFillColor(color2);
        this.add((GObject)gOval);
    }

    private void drawLine(double d, double d2, double d3, double d4, Color color) {
        GLine gLine = new GLine(d, d2, d3, d4);
        gLine.setColor(color);
        this.add((GObject)gLine);
    }

    private void drawPetal(double d, double d2) {
        double d3 = (double)this.getHeight() * 0.07142857142857142;
        this.drawCircle(d, d2, d3, Color.YELLOW, Color.ORANGE);
    }

    private void drawStemAndLeaves(double d, double d2, double d3, double d4) {
        double d5 = d + (d3 - d) * 0.25;
        double d6 = d2 + (d4 - d2) * 0.25;
        double d7 = d + (d3 - d) * 0.5;
        double d8 = d2 + (d4 - d2) * 0.5;
        double d9 = d + (d3 - d) * 0.625;
        double d10 = d2 + (d4 - d2) * 0.625;
        double d11 = d + (d3 - d) * 0.8;
        double d12 = d2 + (d4 - d2) * 0.8;
        double d13 = d3 + (d3 - d) * 0.5;
        double d14 = d2 + (d4 - d2) * 0.1;
        double d15 = d - (d3 - d) * 1.0;
        double d16 = d2 + (d4 - d2) * 0.6;
        this.drawLine(d, d2, d3, d4, Color.GREEN);
        this.drawLine(d5, d6, d13, d14, Color.GREEN);
        this.drawLine(d9, d10, d13, d14, Color.GREEN);
        this.drawLine(d7, d8, d15, d16, Color.GREEN);
        this.drawLine(d11, d12, d15, d16, Color.GREEN);
    }

    private void title() {
        GLabel gLabel = new GLabel("Sunflower");
        gLabel.setColor(Color.MAGENTA);
        gLabel.setFont("Serif-BOLDITALIC-55");
        gLabel.setLocation(0.0, gLabel.getAscent());
        this.add((GObject)gLabel);
    }

    private void signName() {
        GLabel gLabel = new GLabel("Artistry by Shuang Liu");
        gLabel.setColor(Color.CYAN);
        gLabel.setFont("Serif-ITALIC-24");
        double d = (double)this.getWidth() - gLabel.getWidth();
        double d2 = (double)this.getHeight() - gLabel.getDescent();
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

