/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GArc;
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPoint;
import acm.graphics.GPolygon;
import acm.program.GraphicsProgram;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final double PERSON_X = 50.0;
    private static final double PERSON_Y = 200.0;
    private static final double PERSON_WIDTH = 50.0;
    private static final double PERSON_HEIGHT = 150.0;
    private static final Color FACE_COLOR = Color.yellow;
    private static final double EYE_SIZE = 5.555555555555555;
    private static final Color EYE_COLOR = Color.black;
    private static final double KITE_X = 700.0;
    private static final double KITE_Y = 100.0;
    private static final double KITE_DIAG_SIZE = 70.0;
    private static final Color KITE_COLOR = Color.green;
    private static final Color KITE_HORIZONTAL_STICK_COLOR = Color.blue;
    private static final Color KITE_VERTICAL_STICK_COLOR = Color.blue;
    private static final double KITE_TAIL_DIAG_SIZE = 17.5;
    private static final Color KITE_TAIL_COLOR = Color.blue;
    private static final Color KITE_THREAD_COLOR = Color.blue;
    private static final String SIGNATURE = "Artistry by Sumit Saraogi";

    public void run() {
        GPoint gPoint = this.addPerson();
        this.addKite();
        this.addKiteThread(gPoint);
        this.addSignature();
    }

    private GPoint addPerson() {
        this.addFace();
        GPoint gPoint = this.addBody();
        return gPoint;
    }

    private void addFace() {
        this.addFaceStrucutre();
        this.addEyes();
        this.addMouth();
    }

    private void addFaceStrucutre() {
        GOval gOval = new GOval(50.0, 200.0, 50.0, 50.0);
        gOval.setFilled(true);
        gOval.setFillColor(FACE_COLOR);
        this.add((GObject)gOval);
    }

    private void addEyes() {
        double d = 75.0;
        double d2 = 225.0;
        double d3 = 25.0;
        this.addEye(d - d3 / 2.0, d2 - d3 / 2.0, 5.555555555555555);
        this.addEye(d + d3 / 2.0, d2 - d3 / 2.0, 5.555555555555555);
    }

    private void addEye(double d, double d2, double d3) {
        GOval gOval = new GOval(d - d3 / 2.0, d2 - d3 / 2.0, d3, d3);
        gOval.setFilled(true);
        gOval.setFillColor(EYE_COLOR);
        this.add((GObject)gOval);
    }

    private void addMouth() {
        double d = 25.0;
        double d2 = d / 2.0;
        double d3 = 75.0;
        double d4 = 225.0;
        GArc gArc = new GArc(d, d2, 180.0, 180.0);
        this.add((GObject)gArc, d3 - d / 2.0, d4);
    }

    private GPoint addBody() {
        GLine gLine = this.addBodyStructure();
        GPoint gPoint = this.addLimbs(gLine.getStartPoint());
        this.addLimbs(gLine.getEndPoint());
        return gPoint;
    }

    private GLine addBodyStructure() {
        GLine gLine = new GLine(75.0, 250.0, 75.0, 325.0);
        this.add((GObject)gLine);
        return gLine;
    }

    private GPoint addLimbs(GPoint gPoint) {
        double d = gPoint.getX();
        double d2 = gPoint.getY();
        GLine gLine = new GLine(d, d2, d - 25.0, d2 + 25.0);
        this.add((GObject)gLine);
        GLine gLine2 = new GLine(d, d2, d + 25.0, d2 + 25.0);
        this.add((GObject)gLine2);
        return gLine2.getEndPoint();
    }

    private void addKite() {
        this.addKiteStructure();
        this.addKiteTail();
        this.addKiteHorizonatStick();
        this.addKiteVerticalStick();
    }

    private void addKiteStructure() {
        this.addDiamond(700.0, 100.0, 70.0, KITE_COLOR);
    }

    private void addKiteTail() {
        double d = 700.0;
        double d2 = 143.75;
        this.addDiamond(d, d2, 17.5, KITE_TAIL_COLOR);
    }

    private void addDiamond(double d, double d2, double d3, Color color) {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(-d3 / 2.0, 0.0);
        gPolygon.addVertex(0.0, -d3 / 2.0);
        gPolygon.addVertex(d3 / 2.0, 0.0);
        gPolygon.addVertex(0.0, d3 / 2.0);
        gPolygon.setFilled(true);
        gPolygon.setFillColor(color);
        this.add((GObject)gPolygon, d, d2);
    }

    private void addKiteHorizonatStick() {
        GLine gLine = new GLine(665.0, 100.0, 735.0, 100.0);
        gLine.setColor(KITE_HORIZONTAL_STICK_COLOR);
        this.add((GObject)gLine);
    }

    private void addKiteVerticalStick() {
        GLine gLine = new GLine(700.0, 65.0, 700.0, 135.0);
        gLine.setColor(KITE_VERTICAL_STICK_COLOR);
        this.add((GObject)gLine);
    }

    private void addKiteThread(GPoint gPoint) {
        GLine gLine = new GLine(gPoint.getX(), gPoint.getY(), 700.0, 100.0);
        gLine.setColor(KITE_THREAD_COLOR);
        this.add((GObject)gLine);
    }

    private void addSignature() {
        GLabel gLabel = new GLabel(SIGNATURE);
        gLabel.setLocation((double)this.getWidth() - gLabel.getWidth(), (double)this.getHeight() - gLabel.getDescent());
        this.add((GObject)gLabel);
    }
}

