/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GPolygon;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import acm.util.RandomGenerator;
import java.awt.Color;
import java.awt.event.MouseEvent;

public class Artistry
extends GraphicsProgram {
    private static final double HOUSE_SIZE = 200.0;
    private static final double ROOF_OVERHANG = 20.0;
    private static final double DOOR_WIDTH = 40.0;
    private static final double DOOR_HEIGHT = 80.0;
    private static final double SUN_DIAMETER = 70.0;
    private static final double LABEL_PADDING = 5.0;
    private double houseX;
    private double houseY;
    private static final Color NIGHT_SKY_COLOR = Color.BLUE.darker().darker();
    private static final Color NIGHT_HILL_COLOR = Color.GREEN.darker().darker();
    private static final Color NIGHT_HOUSE_COLOR = Color.BLACK;
    private static final Color NIGHT_ROOF_COLOR = Color.BLACK;
    private static final Color NIGHT_DOOR_COLOR = Color.BLACK;
    private static final Color MOON_COLOR = Color.WHITE;
    private static final Color DAY_SKY_COLOR = Color.CYAN;
    private static final Color DAY_HILL_COLOR = Color.GREEN;
    private static final Color DAY_HOUSE_COLOR = new Color(255, 255, 175);
    private static final Color DAY_ROOF_COLOR = new Color(146, 0, 0);
    private static final Color DAY_DOOR_COLOR = new Color(100, 60, 10);
    private static final Color SUN_COLOR = Color.YELLOW;
    private boolean daytime;
    private RandomGenerator rgen = RandomGenerator.getInstance();

    public void run() {
        this.addMouseListeners();
        this.houseX = 0.5 * (double)this.getWidth();
        this.houseY = 0.5 * (double)this.getHeight();
        this.drawDayScene();
        this.daytime = true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1) {
            if (this.daytime) {
                this.drawNightScene();
                this.daytime = false;
            } else {
                this.drawDayScene();
                this.daytime = true;
            }
        } else {
            this.drawRandomScene();
        }
    }

    private void drawDayScene() {
        this.drawScene(DAY_SKY_COLOR, DAY_HILL_COLOR, DAY_HOUSE_COLOR, DAY_ROOF_COLOR, DAY_DOOR_COLOR, SUN_COLOR);
    }

    private void drawNightScene() {
        this.drawScene(NIGHT_SKY_COLOR, NIGHT_HILL_COLOR, NIGHT_HOUSE_COLOR, NIGHT_ROOF_COLOR, NIGHT_DOOR_COLOR, MOON_COLOR);
    }

    private void drawRandomScene() {
        Color color = this.randomColor();
        Color color2 = this.randomColor();
        Color color3 = this.randomColor();
        Color color4 = this.randomColor();
        Color color5 = this.randomColor();
        Color color6 = this.randomColor();
        this.drawScene(color, color2, color3, color4, color5, color6);
    }

    private void drawScene(Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        this.removeAll();
        this.setBackground(color);
        this.drawHill(color2);
        this.drawHouse(color3);
        this.drawRoof(color4);
        this.drawDoor(color5);
        this.drawSun(color6);
        this.drawInstructions();
        this.drawCredits();
    }

    private Color randomColor() {
        int n = this.rgen.nextInt(0, 255);
        int n2 = this.rgen.nextInt(0, 255);
        int n3 = this.rgen.nextInt(0, 255);
        Color color = new Color(n, n2, n3);
        return color;
    }

    private void drawHill(Color color) {
        GOval gOval = new GOval(0.0, (double)(2 * this.getHeight()) / 3.0, (double)this.getWidth(), (double)this.getHeight());
        gOval.setColor(color);
        gOval.setFilled(true);
        this.add((GObject)gOval);
    }

    private void drawHouse(Color color) {
        GRect gRect = new GRect(this.houseX, this.houseY, 200.0, 200.0);
        gRect.setFilled(true);
        gRect.setColor(color);
        this.add((GObject)gRect);
    }

    private void drawRoof(Color color) {
        GPolygon gPolygon = new GPolygon();
        gPolygon.addVertex(-120.0, 0.0);
        gPolygon.addVertex(0.0, -120.0);
        gPolygon.addVertex(120.0, 0.0);
        double d = this.houseX + 100.0;
        double d2 = this.houseY + 20.0;
        gPolygon.setLocation(d, d2);
        gPolygon.setFilled(true);
        gPolygon.setColor(color);
        this.add((GObject)gPolygon);
    }

    private void drawDoor(Color color) {
        double d = this.houseX + 80.0;
        double d2 = this.houseY + 200.0 - 80.0;
        GRect gRect = new GRect(d, d2, 40.0, 80.0);
        gRect.setFilled(true);
        gRect.setColor(color);
        this.add((GObject)gRect);
    }

    private void drawSun(Color color) {
        GOval gOval = new GOval(75.0, 50.0, 70.0, 70.0);
        gOval.setFilled(true);
        gOval.setColor(color);
        this.add((GObject)gOval);
    }

    private void drawInstructions() {
        GLabel gLabel = new GLabel("Left click to toggle day/night");
        GLabel gLabel2 = new GLabel("Right click for random colors");
        double d = (double)this.getWidth() - gLabel.getWidth() - 5.0;
        double d2 = gLabel.getAscent() + 5.0;
        gLabel.setLocation(d, d2);
        double d3 = (double)this.getWidth() - gLabel2.getWidth() - 5.0;
        double d4 = d2 + gLabel.getDescent() + gLabel2.getAscent();
        gLabel2.setLocation(d3, d4);
        this.add((GObject)gLabel);
        this.add((GObject)gLabel2);
    }

    private void drawCredits() {
        GLabel gLabel = new GLabel("Artistry by Trey Deitch");
        double d = (double)this.getWidth() - gLabel.getWidth() - 5.0;
        double d2 = (double)this.getHeight() - gLabel.getDescent() - 5.0;
        gLabel.setLocation(d, d2);
        this.add((GObject)gLabel);
    }
}

