/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GLabel;
import acm.graphics.GLine;
import acm.graphics.GObject;
import acm.graphics.GOval;
import acm.graphics.GRect;
import acm.program.GraphicsProgram;
import acm.util.RandomGenerator;
import java.awt.Color;

public class Artistry
extends GraphicsProgram {
    private static final int NUMBER_BUILDINGS = 24;
    private static final double BUILDING_RANGE = 2.0;
    private static final double BUILDING_MULTIPLIER = 2.0;
    private static final double BUILDING_SPREAD = 20.0;
    private static final double BUILDING_WIDTH_CONSTANT = 1.3;
    private static final double SUPERCHARGER_PROBABILITY = 0.1;
    private static final int MINIMUM_ITERATION = 2;
    private static final int SUN_RAYS = 15;
    private static final int SUN_RADIUS = 20;
    private static final double RAY_EXTENDER = 1.5;
    private RandomGenerator rgen = RandomGenerator.getInstance();

    public void run() {
        double d = (double)(this.getHeight() * 2) / 3.0;
        this.drawHorizon(d);
        this.drawSun(d);
        double d2 = this.rgen.nextDouble((double)this.getWidth() / 3.0, (double)(this.getWidth() * 2) / 3.0);
        for (int i = 0; i < 24; i += Math.min(2, 24 / (i + 1))) {
            this.drawBuilding(i, d2, d);
        }
        this.addSignature();
    }

    private void drawHorizon(double d) {
        GRect gRect = new GRect(0.0, 0.0, (double)this.getWidth(), d);
        gRect.setColor(Color.CYAN);
        gRect.setFilled(true);
        gRect.setFillColor(Color.CYAN);
        this.add((GObject)gRect);
        GRect gRect2 = new GRect(0.0, d, (double)this.getWidth(), d / 2.0);
        gRect2.setColor(Color.GREEN);
        gRect2.setFilled(true);
        gRect2.setFillColor(Color.GREEN);
        this.add((GObject)gRect2);
        this.add((GObject)new GLine(0.0, d, (double)this.getWidth(), d));
    }

    private void drawSun(double d) {
        double d2 = this.rgen.nextDouble(30.0, (double)this.getWidth() - 30.0);
        double d3 = d / 2.0;
        for (int i = 0; i < 15; ++i) {
            GLine gLine = new GLine(d2, d3, d2 + 30.0 * Math.sin((double)(2 * i) * Math.PI / 15.0), d3 + 30.0 * Math.cos((double)(2 * i) * Math.PI / 15.0));
            gLine.setColor(Color.ORANGE);
            this.add((GObject)gLine);
        }
        GOval gOval = new GOval(d2 - 20.0, d3 - 20.0, 40.0, 40.0);
        gOval.setFilled(true);
        gOval.setFillColor(Color.YELLOW);
        gOval.setColor(Color.YELLOW);
        this.add((GObject)gOval);
    }

    private void drawBuilding(int n, double d, double d2) {
        for (int i = 0; i < n; ++i) {
            double d3;
            double d4 = this.rgen.nextDouble(Math.pow((24 - n) / 2, 2.0), Math.pow(((double)(24 - n) + 2.0) / 2.0, 2.0));
            double d5 = this.rgen.nextDouble((double)(24 - n) + 2.0, ((double)(24 - n) + 2.0) / 1.3);
            if (this.rgen.nextDouble(0.0, 1.0) < 0.1) {
                d4 *= this.rgen.nextDouble(1.0, 2.0);
            }
            if ((d3 = this.rgen.nextDouble(d - (double)n * 20.0, d + (double)n * 20.0)) > (double)this.getWidth()) {
                d3 -= (double)this.getWidth();
            } else if (d3 < 0.0) {
                d3 += (double)this.getWidth();
            }
            GRect gRect = new GRect(d3, d2 - d4, d5, d4);
            gRect.setFilled(true);
            gRect.setFillColor(Color.LIGHT_GRAY);
            this.add((GObject)gRect);
            this.pause(10.0);
        }
    }

    private void addSignature() {
        GLabel gLabel = new GLabel("Artistry by Weikang Sun");
        gLabel.setFont("Serif-14");
        gLabel.setLocation((double)this.getWidth() - gLabel.getWidth(), (double)this.getHeight() - gLabel.getHeight() + gLabel.getAscent());
        gLabel.setColor(Color.BLUE);
        this.add((GObject)gLabel);
    }
}

