/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acmx.classfile.Attribute;
import acmx.classfile.JavaClass;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaField {
    private ArrayList<Attribute> attributes;
    private JavaClass owner;
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;

    public JavaField(DataInputStream in, JavaClass jc) throws IOException {
        this.owner = jc;
        this.accessFlags = in.readShort();
        this.nameIndex = in.readShort();
        this.descriptorIndex = in.readShort();
        int count = in.readShort();
        this.attributes = new ArrayList();
        int i = 0;
        while (i < count) {
            this.attributes.add(new Attribute(in, this.owner));
            ++i;
        }
    }

    public JavaClass getOwner() {
        return this.owner;
    }

    public String getEntryTypeName() {
        return "Field";
    }

    public String getName() {
        return this.owner.getUTF8Name(this.nameIndex);
    }

    public void setNameIndex(String name) {
        this.nameIndex = this.owner.createUTF8Entry(name);
    }

    public String getDescriptor() {
        return this.getOwner().getUTF8Name(this.descriptorIndex);
    }

    public void setDescriptor(String name) {
        this.descriptorIndex = this.getOwner().createUTF8Entry(name);
    }

    public int getAttributeCount() {
        return this.attributes.size();
    }

    public Attribute getAttribute(int index) {
        return this.attributes.get(index);
    }

    public Attribute getAttribute(String name) {
        int i = 0;
        while (i < this.attributes.size()) {
            Attribute attribute = this.attributes.get(i);
            if (attribute.getName().equals(name)) {
                return attribute;
            }
            ++i;
        }
        return null;
    }

    public Iterator<Attribute> attributeIterator() {
        return this.attributes.iterator();
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.accessFlags);
        out.writeShort(this.nameIndex);
        out.writeShort(this.descriptorIndex);
        out.writeShort(this.attributes.size());
        int i = 0;
        while (i < this.attributes.size()) {
            this.attributes.get(i).write(out);
            ++i;
        }
    }

    public String toString() {
        String descriptor = this.getDescriptor();
        String str = "";
        if (descriptor.startsWith("(")) {
            int paren = descriptor.indexOf(")");
            str = JavaClass.typeToString(descriptor.substring(paren + 1));
            str = String.valueOf(str) + " " + this.getName();
            str = String.valueOf(str) + "(" + JavaClass.typeToString(descriptor.substring(1, paren)) + ")";
        } else {
            str = String.valueOf(JavaClass.typeToString(descriptor)) + " " + this.getName();
        }
        if (this.attributes.size() > 0) {
            str = String.valueOf(str) + " {";
            int i = 0;
            while (i < this.attributes.size()) {
                Attribute attribute = this.attributes.get(i);
                if (i > 0) {
                    str = String.valueOf(str) + "+";
                }
                str = String.valueOf(str) + attribute.getName();
                ++i;
            }
            str = String.valueOf(str) + "}";
        }
        return "[" + this.getEntryTypeName() + ":" + str + "]";
    }
}

