/*
 * Decompiled with CFR 0.152.
 */
package acm.program;

import acm.io.IOConsole;
import acm.program.OldStyleCheckBoxMenuItem;
import acm.program.OldStyleMenuItem;
import acm.program.Program;
import acm.program.ProgramMenuListener;
import acm.util.ErrorException;
import acm.util.Platform;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.lang.reflect.Method;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ProgramMenuBar
extends JMenuBar {
    private Program activeProgram;
    private ProgramMenuListener listener = new ProgramMenuListener(this);
    private IOConsole activeConsole;
    private Method updateMenuBar;

    public ProgramMenuBar() {
        this.init();
        this.addMenuExtensions();
    }

    public void init() {
        this.addFileMenu();
        this.addEditMenu();
    }

    public void update() {
        if (this.updateMenuBar != null) {
            try {
                Object[] args = new Object[]{this};
                this.updateMenuBar.invoke(null, args);
            }
            catch (Exception ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public void addFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        this.addFileMenuItems(fileMenu);
        this.add(fileMenu);
    }

    public void addEditMenu() {
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        this.addEditMenuItems(editMenu);
        this.add(editMenu);
    }

    public void addFileMenuItems(JMenu menu) {
        menu.add(this.createStandardMenuItem("Save"));
        menu.add(this.createStandardMenuItem("Save As"));
        menu.addSeparator();
        menu.add(this.createStandardMenuItem("Print"));
        menu.add(this.createStandardMenuItem("Print Console"));
        menu.add(this.createStandardMenuItem("Script"));
        menu.addSeparator();
        menu.add(this.createStandardMenuItem("Quit"));
    }

    public void addEditMenuItems(JMenu menu) {
        menu.add(this.createStandardMenuItem("Cut"));
        menu.add(this.createStandardMenuItem("Copy"));
        menu.add(this.createStandardMenuItem("Paste"));
        menu.add(this.createStandardMenuItem("Select All"));
    }

    public JMenuItem createStandardMenuItem(String action) {
        JMenuItem item = null;
        if (action.equals("Quit")) {
            item = Platform.isMac() ? this.createStandardItem("Quit", 81) : this.createStandardItem("Exit", 0);
        } else if (action.equals("Cut")) {
            item = this.createStandardItem(Platform.isMac() ? "Cut" : "Cut (x)", 88);
        } else if (action.equals("Copy")) {
            item = this.createStandardItem(Platform.isMac() ? "Copy" : "Copy (c)", 67);
        } else if (action.equals("Paste")) {
            item = this.createStandardItem(Platform.isMac() ? "Paste" : "Paste (v)", 86);
        } else if (action.equals("Save")) {
            item = this.createStandardItem("Save", 83);
        } else if (action.equals("Save As")) {
            item = this.createStandardItem("Save As...", 0);
        } else if (action.equals("Print")) {
            item = this.createStandardItem("Print...", 80);
        } else if (action.equals("Print Console")) {
            item = this.createStandardItem("Print Console", 0);
        } else if (action.equals("Script")) {
            item = this.createStandardItem("Script...", 0);
        } else if (action.equals("Select All")) {
            item = this.createStandardItem("Select All", 65);
        } else if (action.equals("Export Applet")) {
            item = this.createStandardItem("Export Applet...", 0);
        } else if (action.equals("Submit Project")) {
            item = this.createStandardItem("Submit Project...", 0);
        } else {
            throw new ErrorException("Illegal standard menu item: " + action);
        }
        item.setActionCommand(action);
        item.addActionListener(this.listener);
        return item;
    }

    public Program getProgram() {
        return this.activeProgram;
    }

    public void setConsole(IOConsole console) {
        this.activeConsole = console;
    }

    public IOConsole getConsole() {
        return this.activeConsole;
    }

    public void setEnabled(String action, boolean flag) {
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            this.setEnabled(this.getMenu(i), action, flag);
            ++i;
        }
    }

    public MenuBar createOldStyleMenuBar() {
        MenuBar mbar = new MenuBar();
        int nMenus = this.getMenuCount();
        int i = 0;
        while (i < nMenus) {
            mbar.add(this.createOldStyleMenu(this.getMenu(i)));
            ++i;
        }
        return mbar;
    }

    protected void addMenuExtensions() {
        try {
            Class<?> menuExtensionsClass = Class.forName("acmx.menu.MenuExtensions");
            Class[] types = new Class[]{Class.forName("acm.program.ProgramMenuBar")};
            Method extendMenuBar = menuExtensionsClass.getMethod("extendMenuBar", types);
            this.updateMenuBar = menuExtensionsClass.getMethod("updateMenuBar", types);
            Object[] args = new Object[]{this};
            extendMenuBar.invoke(null, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setProgram(Program program) {
        this.activeProgram = program;
    }

    private JMenuItem createStandardItem(String label, int key) {
        JMenuItem item = new JMenuItem(label);
        if (key != 0) {
            if (Platform.isMac()) {
                item.setAccelerator(KeyStroke.getKeyStroke((int)((char)key), 2));
            } else {
                item.setMnemonic(key);
            }
        }
        return item;
    }

    private Menu createOldStyleMenu(JMenu jmenu) {
        Menu menu = new Menu(jmenu.getText());
        int nItems = jmenu.getItemCount();
        int i = 0;
        while (i < nItems) {
            menu.add(this.createOldStyleMenuItem(jmenu.getItem(i)));
            ++i;
        }
        return menu;
    }

    private MenuItem createOldStyleMenuItem(Object jitem) {
        if (jitem == null) {
            return new MenuItem("-");
        }
        if (jitem instanceof JMenu) {
            return this.createOldStyleMenu((JMenu)jitem);
        }
        if (jitem instanceof JCheckBoxMenuItem) {
            return new OldStyleCheckBoxMenuItem((JCheckBoxMenuItem)jitem);
        }
        if (jitem instanceof JMenuItem) {
            return new OldStyleMenuItem((JMenuItem)jitem);
        }
        throw new ErrorException("Unsupported menu item type");
    }

    private void setEnabled(JMenu item, String action, boolean flag) {
        JMenu menu = item;
        int nItems = menu.getItemCount();
        int i = 0;
        while (i < nItems) {
            JMenuItem subItem = menu.getItem(i);
            if (subItem != null) {
                this.setEnabled(subItem, action, flag);
            }
            ++i;
        }
    }

    private void setEnabled(JMenuItem item, String action, boolean flag) {
        if (action.equals(item.getActionCommand())) {
            item.setEnabled(flag);
        }
    }
}

