/*
 * Decompiled with CFR 0.152.
 */
package acmx.classfile;

import acmx.classfile.ConstantPoolEntry;
import acmx.classfile.JavaClass;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstantPoolIterator
implements Iterator<ConstantPoolEntry> {
    private JavaClass targetClass;
    private int entryCount;
    private int entryIndex;

    public ConstantPoolIterator(JavaClass jc) {
        this.targetClass = jc;
        this.entryCount = jc.getConstantPoolCount();
        this.entryIndex = 1;
    }

    @Override
    public boolean hasNext() {
        return this.entryIndex < this.entryCount;
    }

    @Override
    public ConstantPoolEntry next() {
        ConstantPoolEntry entry;
        if ((entry = this.targetClass.getConstantPoolEntry(this.entryIndex++)).takesTwoSlots()) {
            ++this.entryIndex;
        }
        return entry;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

