/*
 * Decompiled with CFR 0.152.
 */
package acmx.export;

import acm.program.Program;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

class ExportAppletDialog
extends JFileChooser {
    private JCheckBox jdk11CheckBox;
    private JCheckBox exportFilesCheckBox;
    private Component target;

    public ExportAppletDialog(File dir, Program program) {
        super(dir);
        this.setFileSelectionMode(1);
        this.setDialogTitle("Export Applet");
        this.setSelectedFile(new File(dir, program.getClass().getName()));
        this.jdk11CheckBox = new JCheckBox("Make JDK 1.1 compatible  ");
        this.jdk11CheckBox.setSelected(true);
        this.exportFilesCheckBox = new JCheckBox("Export resource files");
        this.exportFilesCheckBox.setSelected(true);
        this.target = program;
    }

    protected JDialog createDialog(Component parent) {
        JDialog dialog = super.createDialog(parent);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(this.jdk11CheckBox);
        panel.add(this.exportFilesCheckBox);
        dialog.getContentPane().add((Component)panel, "South");
        dialog.validate();
        return dialog;
    }

    public File chooseOutputDirectory() {
        int result = this.showSaveDialog(this.target);
        if (result == 1) {
            return null;
        }
        return this.getSelectedFile();
    }

    public boolean makeJDK11Compatible() {
        return this.jdk11CheckBox.isSelected();
    }

    public boolean exportFiles() {
        return this.exportFilesCheckBox.isSelected();
    }
}

