/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.AWTDialogModel;
import acm.io.DialogModel;
import acm.io.IOConsole;
import acm.io.IOModel;
import acm.util.CancelledException;
import acm.util.ErrorException;
import acm.util.Platform;
import java.awt.Component;
import java.lang.reflect.Constructor;
import javax.swing.JPanel;

public class IODialog
implements IOModel {
    private boolean exceptionOnError;
    private boolean allowCancel;
    private DialogModel model;
    private Component myComponent;
    private IOConsole myConsole;
    private String outputLine;

    public IODialog() {
        this(null);
    }

    public IODialog(Component owner) {
        this.myComponent = owner;
        this.model = this.createModel();
        this.outputLine = "";
        this.exceptionOnError = false;
        this.allowCancel = false;
    }

    public void print(String value) {
        this.outputLine = String.valueOf(this.outputLine) + value;
    }

    public final void print(boolean x) {
        this.print("" + x);
    }

    public final void print(char x) {
        this.print("" + x);
    }

    public final void print(double x) {
        this.print("" + x);
    }

    public final void print(float x) {
        this.print("" + x);
    }

    public final void print(int x) {
        this.print("" + x);
    }

    public final void print(long x) {
        this.print("" + x);
    }

    public final void print(Object x) {
        this.print("" + x);
    }

    public void println() {
        this.model.popupMessage(this.outputLine);
        this.outputLine = "";
    }

    public void println(String value) {
        this.print(value);
        this.println();
    }

    public final void println(boolean x) {
        this.println("" + x);
    }

    public final void println(char x) {
        this.println("" + x);
    }

    public final void println(double x) {
        this.println("" + x);
    }

    public final void println(float x) {
        this.println("" + x);
    }

    public final void println(int x) {
        this.println("" + x);
    }

    public final void println(long x) {
        this.println("" + x);
    }

    public final void println(Object x) {
        this.println("" + x);
    }

    public void showErrorMessage(String msg) {
        this.model.popupErrorMessage(msg);
    }

    public final String readLine() {
        return this.readLine(null);
    }

    public String readLine(String prompt) {
        String line;
        if (this.myConsole != null && this.myConsole.getInputScript() != null) {
            return this.myConsole.readLine(prompt);
        }
        prompt = prompt == null ? this.outputLine : String.valueOf(this.outputLine) + prompt;
        this.outputLine = "";
        while ((line = this.model.popupLineInputDialog(prompt, this.allowCancel)) == null) {
            if (!this.allowCancel) continue;
            throw new CancelledException();
        }
        return line;
    }

    public final int readInt() {
        return this.readInt(null, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public final int readInt(int low, int high) {
        return this.readInt(null, low, high);
    }

    public final int readInt(String prompt) {
        return this.readInt(prompt, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public int readInt(String prompt, int low, int high) {
        while (true) {
            String line = this.readLine(prompt);
            try {
                int n = Integer.parseInt(line);
                if (n < low || n > high) {
                    this.signalError("Value is outside the range [" + low + ":" + high + "]");
                }
                return n;
            }
            catch (NumberFormatException ex) {
                this.signalError("Illegal integer format");
                continue;
            }
            break;
        }
    }

    public final double readDouble() {
        return this.readDouble(null, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public final double readDouble(double low, double high) {
        return this.readDouble(null, low, high);
    }

    public final double readDouble(String prompt) {
        return this.readDouble(prompt, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    public double readDouble(String prompt, double low, double high) {
        while (true) {
            String line = this.readLine(prompt);
            try {
                double d = Double.valueOf(line);
                if (d < low || d > high) {
                    this.signalError("Value is outside the range [" + low + ":" + high + "]");
                }
                return d;
            }
            catch (NumberFormatException ex) {
                this.signalError("Illegal numeric format");
                continue;
            }
            break;
        }
    }

    public final boolean readBoolean() {
        return this.readBoolean(null);
    }

    public final boolean readBoolean(String prompt) {
        return this.readBoolean(prompt, "true", "false");
    }

    public boolean readBoolean(String prompt, String trueLabel, String falseLabel) {
        Boolean choice;
        if (this.myConsole != null && this.myConsole.getInputScript() != null) {
            return this.myConsole.readBoolean(prompt, trueLabel, falseLabel);
        }
        prompt = prompt == null ? this.outputLine : String.valueOf(this.outputLine) + prompt;
        this.outputLine = "";
        while ((choice = this.model.popupBooleanInputDialog(prompt, trueLabel, falseLabel, this.allowCancel)) == null) {
            if (!this.allowCancel) continue;
            throw new CancelledException();
        }
        return choice;
    }

    public void setExceptionOnError(boolean flag) {
        this.exceptionOnError = flag;
    }

    public boolean getExceptionOnError() {
        return this.exceptionOnError;
    }

    public void setAllowCancel(boolean flag) {
        this.allowCancel = flag;
    }

    public boolean getAllowCancel() {
        return this.allowCancel;
    }

    public void setAssociatedConsole(IOConsole console) {
        this.myConsole = console;
    }

    public IOConsole getAssociatedConsole() {
        return this.myConsole;
    }

    protected DialogModel createModel() {
        String className = new JPanel().getClass().getName();
        if (className.startsWith("javax.swing.") && Platform.isSwingAvailable()) {
            try {
                Class<?> swingDialogModelClass = Class.forName("acm.io.SwingDialogModel");
                Class[] types = new Class[]{Class.forName("java.awt.Component")};
                Object[] args = new Object[]{this.myComponent};
                Constructor<?> con = swingDialogModelClass.getConstructor(types);
                return (DialogModel)con.newInstance(args);
            }
            catch (Exception ex) {
                return new AWTDialogModel(this.myComponent);
            }
        }
        return new AWTDialogModel(this.myComponent);
    }

    private void signalError(String msg) {
        if (this.exceptionOnError) {
            throw new ErrorException(msg);
        }
        this.model.popupErrorMessage(msg);
    }
}

