/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acm.util.JTFTools;
import acm.util.Platform;
import acmx.export.javax.swing.JApplet;
import acmx.export.javax.swing.JComboBox;
import acmx.export.javax.swing.JComboBoxModel;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

class AWTComboBox
extends Component
implements JComboBoxModel,
MouseListener,
ItemListener {
    private static final int MARGIN = 3;
    private static final int MIN_WIDTH = 48;
    private static final int MIN_HEIGHT = 22;
    private static final int CONTROL_WIDTH = 22;
    private static final Color BGCOLOR = JApplet.BGCOLOR;
    private static final Color BORDER_COLOR = new Color(0x666666);
    private static final Color CONTROL_COLOR = new Color(0x9999FF);
    private static final Font FONT = new Font("SansSerif", 1, 10);
    private ArrayList<Object> items;
    private ArrayList<ActionListener> actionListeners;
    private ArrayList<ItemListener> itemListeners;
    private int selectedIndex;
    private String actionCommand;
    private PopupMenu popup;
    private JComboBox target;

    public AWTComboBox() {
        this.setBackground(BGCOLOR);
        this.setFont(JTFTools.getStandardFont(FONT));
        this.addMouseListener(this);
        this.actionListeners = new ArrayList();
        this.itemListeners = new ArrayList();
        this.items = new ArrayList();
        this.popup = new PopupMenu();
        this.add(this.popup);
        this.selectedIndex = -1;
    }

    public void setSource(JComboBox source) {
        this.target = source;
    }

    public void addItem(Object item) {
        this.items.add(item);
        CheckboxMenuItem popupItem = new CheckboxMenuItem("" + item);
        popupItem.addItemListener(this);
        this.popup.add(popupItem);
    }

    public void setSelectedIndex(int index) {
        this.select(index);
        int nItems = this.popup.getItemCount();
        int i = 0;
        while (i < nItems) {
            CheckboxMenuItem popupItem = (CheckboxMenuItem)this.popup.getItem(i);
            popupItem.setState(index == i);
            ++i;
        }
    }

    public void setSelectedItem(Object item) {
        int selected = -1;
        int nItems = this.items.size();
        int i = 0;
        while (i < nItems) {
            boolean state = item.equals(this.items.get(i));
            CheckboxMenuItem popupItem = (CheckboxMenuItem)this.popup.getItem(i);
            popupItem.setState(state);
            if (state) {
                selected = i;
            }
            ++i;
        }
        this.select(selected);
    }

    public Object getSelectedItem() {
        return this.items.get(this.selectedIndex);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListeners.remove(listener);
    }

    public void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.actionListeners.get(i).actionPerformed(e);
            ++i;
        }
    }

    public void setActionCommand(String cmd) {
        this.actionCommand = cmd;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void addItemListener(ItemListener listener) {
        this.itemListeners.add(listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.itemListeners.remove(listener);
    }

    public void fireItemListeners(ItemEvent e) {
        int nListeners = this.itemListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.itemListeners.get(i).itemStateChanged(e);
            ++i;
        }
    }

    public Object[] getSelectedObjects() {
        if (this.selectedIndex == -1) {
            return new Object[0];
        }
        Object[] selected = new Object[]{this.getSelectedItem()};
        return selected;
    }

    public void setEditable(boolean editable) {
    }

    public boolean isEditable() {
        return false;
    }

    public Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int nItems = this.popup.getItemCount();
        int width = 48;
        int i = 0;
        while (i < nItems) {
            CheckboxMenuItem item = (CheckboxMenuItem)this.popup.getItem(i);
            width = Math.max(width, fm.stringWidth(item.getLabel()) + 6);
            ++i;
        }
        int height = Math.max(fm.getHeight() + 2, 22);
        return new Dimension(width + 22, height);
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width - 22, size.height);
        g.setColor(CONTROL_COLOR);
        g.fillRect(size.width - 22, 0, 22, size.height);
        g.setColor(Color.BLACK);
        int x = size.width - 11;
        int y = size.height / 2;
        int i = 2;
        while (i <= 5) {
            g.drawLine(x - (5 - i), y - i, x + (5 - i), y - i);
            g.drawLine(x - (5 - i), y + i, x + (5 - i), y + i);
            ++i;
        }
        g.setColor(BORDER_COLOR);
        g.drawRect(0, 0, size.width - 2, size.height - 2);
        g.setColor(Color.WHITE);
        g.drawRect(1, 1, size.width - 2, size.height - 2);
        g.setColor(this.getBackground());
        g.drawLine(1, size.height - 1, 1, size.height - 1);
        g.drawLine(size.width - 1, 1, size.width - 1, 1);
        if (this.selectedIndex != -1) {
            g.setColor(this.getForeground());
            FontMetrics fm = g.getFontMetrics();
            x = 3;
            y = (size.height + fm.getAscent()) / 2 - 2;
            g.drawString("" + this.getSelectedItem(), x, y);
        }
    }

    public void mousePressed(MouseEvent e) {
        this.popup.show(this, 0, this.computeYOffset(e.getY()));
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.setSelectedIndex(this.findPopupIndex((String)e.getItem()));
        }
    }

    public int findPopupIndex(String label) {
        int nItems = this.popup.getItemCount();
        int i = 0;
        while (i < nItems) {
            if (label == this.popup.getItem(i).getLabel()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int computeYOffset(int mouseY) {
        Font font = this.popup.getFont();
        if (font == null || Platform.isMac()) {
            font = new Font("Dialog", 0, 12);
        }
        FontMetrics fm = this.getFontMetrics(font);
        int height = fm.getHeight();
        return -(this.getSelectedIndex() * height - height / 2 + mouseY);
    }

    private void select(int index) {
        if (this.itemListeners.size() > 0 && this.selectedIndex != -1) {
            this.fireItemListeners(this.createItemEvent(2));
        }
        this.selectedIndex = index;
        if (this.itemListeners.size() > 0 && this.selectedIndex != -1) {
            this.fireItemListeners(this.createItemEvent(1));
        }
        if (this.actionListeners.size() > 0 && this.selectedIndex != -1) {
            this.fireActionListeners(this.createActionEvent());
        }
        this.repaint();
    }

    private ItemEvent createItemEvent(int change) {
        return new ItemEvent(this.target, 701, this.getSelectedItem(), change);
    }

    private ActionEvent createActionEvent() {
        return new ActionEvent(this.target, 1001, this.actionCommand);
    }
}

