/*
 * Decompiled with CFR 0.152.
 */
package acm.io;

import acm.io.CharacterQueue;
import acm.io.ConsoleInputMonitor;
import acm.io.ConsoleModel;
import acm.io.ConsoleOutputMonitor;
import acm.io.IOConsole;
import acm.program.Program;
import acm.program.ProgramMenuBar;
import acm.util.ErrorException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

class StandardConsoleModel
implements KeyListener,
FocusListener,
ConsoleModel {
    private static final int PRINT_MARGIN = 36;
    private ConsoleOutputMonitor outputMonitor = new ConsoleOutputMonitor(this);
    private ConsoleInputMonitor inputMonitor = new ConsoleInputMonitor(this);
    private BufferedReader inputScript;
    private CharacterQueue buffer;
    private SimpleAttributeSet outputAttributes;
    private SimpleAttributeSet inputAttributes;
    private SimpleAttributeSet errorAttributes;
    private JScrollPane scrollPane = new JScrollPane(22, 32);
    private JTextPane textPane = new JTextPane();
    private Document document;
    private String lineSeparator;
    private int base;
    private boolean hasFocus;
    private IOConsole console;

    public StandardConsoleModel() {
        this.textPane.addKeyListener(this);
        this.textPane.addFocusListener(this);
        this.scrollPane.setViewportView(this.textPane);
        this.document = this.textPane.getDocument();
        this.lineSeparator = System.getProperty("line.separator");
        this.outputAttributes = new SimpleAttributeSet();
        this.inputAttributes = new SimpleAttributeSet();
        this.errorAttributes = new SimpleAttributeSet();
        this.buffer = new CharacterQueue();
        this.base = 0;
    }

    public void setConsole(IOConsole owner) {
        this.console = owner;
    }

    public IOConsole getConsole() {
        return this.console;
    }

    public void print(String str, int style) {
        this.outputMonitor.print(str, style);
    }

    public String readLine() {
        return this.inputMonitor.readLine();
    }

    public void setInputScript(BufferedReader rd) {
        this.inputScript = rd;
        if (this.buffer.isWaiting()) {
            try {
                String line = this.inputScript.readLine();
                this.buffer.enqueue(String.valueOf(line) + "\n");
            }
            catch (IOException ex) {
                throw new ErrorException(ex);
            }
        }
    }

    public BufferedReader getInputScript() {
        return this.inputScript;
    }

    public void clear() {
        this.textPane.setText("");
        this.base = 0;
        this.buffer.clear();
    }

    public String getText() {
        return this.textPane.getText();
    }

    public String getText(int start, int end) {
        try {
            return this.document.getText(start, end - start);
        }
        catch (BadLocationException ex) {
            throw new ErrorException(ex);
        }
    }

    public int getLength() {
        return this.document.getLength();
    }

    public Component getConsolePane() {
        return this.scrollPane;
    }

    public Component getTextPane() {
        return this.textPane;
    }

    public void cut() {
        this.copy();
        this.deleteSelection();
    }

    public void copy() {
        this.textPane.copy();
    }

    public void paste() {
        if (this.textPane.getSelectionEnd() != this.document.getLength()) {
            return;
        }
        int start = this.deleteSelection();
        this.textPane.setSelectionStart(start);
        this.textPane.paste();
        this.textPane.select(this.document.getLength(), this.document.getLength());
        if (this.document instanceof DefaultStyledDocument) {
            DefaultStyledDocument doc = (DefaultStyledDocument)this.document;
            doc.setCharacterAttributes(start, this.textPane.getSelectionEnd() - start, this.inputAttributes, true);
        }
    }

    public void selectAll() {
        this.textPane.selectAll();
    }

    public boolean isPointSelection() {
        return this.textPane.getSelectionStart() == this.textPane.getSelectionEnd();
    }

    public void print(PrintJob pj) {
        Element e;
        int linesPerPage;
        Graphics g = pj.getGraphics();
        Dimension pageSize = pj.getPageDimension();
        FontMetrics fm = this.textPane.getFontMetrics(this.textPane.getFont());
        int fontHeight = fm.getHeight();
        int fontAscent = fm.getAscent();
        int x = 36;
        int y = 36 + fontAscent;
        int linesRemaining = linesPerPage = (pageSize.height - 72) / fontHeight;
        ElementIterator i = new ElementIterator(this.document);
        block2: while ((e = i.next()) != null) {
            if (!e.isLeaf()) continue;
            try {
                int len = e.getEndOffset() - e.getStartOffset();
                this.setStyleFromAttributes(g, e.getAttributes());
                fm = g.getFontMetrics();
                String text = this.document.getText(e.getStartOffset(), len);
                int start = 0;
                while (true) {
                    boolean last = false;
                    int delta = 1;
                    int eol = text.indexOf("\n", start);
                    if (eol == -1) {
                        eol = text.indexOf(this.lineSeparator, start);
                        if (eol == -1) {
                            eol = text.length();
                            last = true;
                        } else {
                            delta = this.lineSeparator.length();
                        }
                    }
                    if (start < eol) {
                        String str = text.substring(start, eol);
                        g.drawString(str, x, y);
                        x += fm.stringWidth(str);
                    }
                    if (last) continue block2;
                    start = eol + delta;
                    x = 36;
                    y += fontHeight;
                    if (--linesRemaining > 0) continue;
                    g.dispose();
                    g = pj.getGraphics();
                    y = 36 + fontAscent;
                    linesRemaining = linesPerPage;
                }
            }
            catch (BadLocationException ex) {
                throw new ErrorException(ex);
            }
        }
        pj.end();
    }

    public void setInputStyle(int style) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.inputAttributes.addAttribute(StyleConstants.Bold, new Boolean((style & 1) != 0));
        this.inputAttributes.addAttribute(StyleConstants.Italic, new Boolean((style & 2) != 0));
    }

    public void setInputColor(Color color) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.inputAttributes.addAttribute(StyleConstants.Foreground, color);
    }

    public void setErrorStyle(int style) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.errorAttributes.addAttribute(StyleConstants.Bold, new Boolean((style & 1) != 0));
        this.errorAttributes.addAttribute(StyleConstants.Italic, new Boolean((style & 2) != 0));
    }

    public void setErrorColor(Color color) {
        if (this.getLength() != 0) {
            throw new ErrorException("Console styles and colors cannot be changed after I/O has started.");
        }
        this.errorAttributes.addAttribute(StyleConstants.Foreground, color);
    }

    public void requestFocus() {
        if (this.textPane != null) {
            this.textPane.requestFocus();
        }
    }

    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        ProgramMenuBar mbar = this.findMenuBar();
        if (mbar != null) {
            mbar.setConsole(this.console);
            this.updateMenuBar(mbar);
        }
    }

    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
    }

    public void keyTyped(KeyEvent e) {
        this.buffer.enqueue(e.getKeyChar());
        e.consume();
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                this.buffer.enqueue('\u0002');
                break;
            }
            case 39: {
                this.buffer.enqueue('\u0006');
            }
        }
        e.consume();
    }

    public void keyReleased(KeyEvent e) {
        e.consume();
    }

    private void updateMenuBar(ProgramMenuBar mbar) {
        mbar.setEnabled("Cut", true);
        mbar.setEnabled("Copy", true);
        mbar.setEnabled("Paste", true);
        mbar.setEnabled("Select All", true);
        mbar.setEnabled("Save", true);
        mbar.setEnabled("Save As", true);
        mbar.setEnabled("Script", true);
        mbar.setEnabled("Print Console", true);
    }

    protected void printCallback(String str, int style) {
        this.insert(str, this.base, style);
        this.base += str.length();
        this.setCaretPosition(this.base);
    }

    protected String readLineCallback() {
        char ch;
        this.base = this.getLength();
        if (this.inputScript != null) {
            String line = null;
            try {
                line = this.inputScript.readLine();
            }
            catch (IOException ex) {
                throw new ErrorException(ex);
            }
            if (line != null) {
                this.insert(line, this.base, 1);
                this.insert("\n", this.base + line.length(), 0);
                this.base += line.length() + 1;
                return line;
            }
            try {
                this.inputScript.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            this.inputScript = null;
        }
        this.setCaretPosition(this.base);
        while ((ch = this.buffer.dequeue()) != '\n' && ch != '\r') {
            if (this.getCaretPosition() < this.base) {
                this.setCaretPosition(this.getLength());
            }
            int dot = this.getSelectionStart();
            switch (ch) {
                case '\b': 
                case '\u007f': {
                    if (dot == this.getSelectionEnd()) {
                        if (dot <= this.base) break;
                        this.delete(dot - 1, dot);
                        --dot;
                        break;
                    }
                    dot = this.deleteSelection();
                    break;
                }
                case '\u0001': {
                    this.selectAll();
                    dot = -1;
                    break;
                }
                case '\u0002': {
                    dot = Math.max(this.getSelectionStart() - 1, this.base);
                    break;
                }
                case '\u0003': {
                    this.copy();
                    dot = -1;
                    break;
                }
                case '\u0006': {
                    dot = Math.min(this.getSelectionEnd() + 1, this.getLength());
                    break;
                }
                case '\u0010': {
                    this.console.printConsole();
                    dot = -1;
                    break;
                }
                case '\u0013': {
                    this.console.save();
                    dot = -1;
                    break;
                }
                case '\u0016': {
                    this.paste();
                    dot = -1;
                    break;
                }
                case '\u0018': {
                    this.cut();
                    dot = -1;
                    break;
                }
                default: {
                    if (dot != this.getSelectionEnd()) {
                        dot = this.deleteSelection();
                    }
                    this.insert("" + ch, dot, 1);
                    ++dot;
                }
            }
            if (dot == -1) continue;
            this.select(dot, dot);
            this.setCaretPosition(dot);
        }
        int len = this.getLength() - this.base;
        String line = this.getText(this.base, this.base + len);
        this.insert("\n", this.base + len, 0);
        this.base += len + 1;
        return line;
    }

    public boolean isCommandEnabled(String cmd) {
        if (cmd == cmd) {
            // empty if block
        }
        return this.hasFocus;
    }

    private void insert(String str, int dot, int style) {
        try {
            SimpleAttributeSet attributes = this.outputAttributes;
            switch (style) {
                case 1: {
                    attributes = this.inputAttributes;
                    break;
                }
                case 2: {
                    attributes = this.errorAttributes;
                }
            }
            this.document.insertString(dot, str, attributes);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void delete(int p1, int p2) {
        try {
            this.document.remove(p1, p2 - p1);
        }
        catch (BadLocationException ex) {
            throw new ErrorException(ex);
        }
    }

    private void setCaretPosition(int pos) {
        this.textPane.setCaretPosition(pos);
    }

    private int getCaretPosition() {
        return this.textPane.getCaretPosition();
    }

    private void select(int p1, int p2) {
        this.textPane.select(p1, p2);
    }

    private int getSelectionStart() {
        return this.textPane.getSelectionStart();
    }

    private int getSelectionEnd() {
        return this.textPane.getSelectionEnd();
    }

    private int deleteSelection() {
        int start = Math.max(this.base, this.getSelectionStart());
        int end = this.getSelectionEnd();
        if (end <= this.base) {
            return this.getLength();
        }
        this.delete(start, end);
        return start;
    }

    private ProgramMenuBar findMenuBar() {
        Container comp = this.console;
        while (comp != null) {
            if (comp instanceof Program) {
                return ((Program)comp).getMenuBar();
            }
            if (comp instanceof JFrame) {
                JMenuBar mbar = ((JFrame)comp).getJMenuBar();
                return mbar instanceof ProgramMenuBar ? (ProgramMenuBar)mbar : null;
            }
            comp = comp.getParent();
        }
        return null;
    }

    private void setStyleFromAttributes(Graphics g, AttributeSet attributes) {
        Font oldFont = this.textPane.getFont();
        int style = 0;
        if (Boolean.TRUE.equals(attributes.getAttribute(StyleConstants.Bold))) {
            style |= 1;
        }
        if (Boolean.TRUE.equals(attributes.getAttribute(StyleConstants.Italic))) {
            style |= 2;
        }
        g.setFont(new Font(oldFont.getName(), style, oldFont.getSize()));
        Color color = (Color)attributes.getAttribute(StyleConstants.Foreground);
        if (color == null) {
            color = this.textPane.getForeground();
        }
        g.setColor(color);
    }
}

