import acm.graphics.*;
import acm.program.*;
import java.awt.event.*;
import javax.swing.*;

public class InteractiveKarel extends GraphicsProgram{ 
	
	public void init() { 
		initControlStrip(); 
		initKarel(); 
		addActionListeners(); 
	} 

	public void actionPerformed(ActionEvent e) { 
		String cmd = e.getActionCommand(); 
		if (cmd.equals("move")) { 
			move(); 
		} else if (cmd.equals("turnLeft")) { 
			turnLeft(); 
		} 
	} 

	private void initKarel() { 
		karel = new GImage("KarelEast.jpg"); 
		karel.setSize(KAREL_SIZE, KAREL_SIZE);
		x = 0; 
		y = 0; 
		dir = EAST_DIR; 
		add(karel, x, y);		
	} 

	private void move() { 
		double nx = x; 
		double ny = y; 
		switch (dir) { 
			case NORTH_DIR: ny -= KAREL_SIZE; break; 
			case EAST_DIR:  nx += KAREL_SIZE; break; 
			case SOUTH_DIR: ny += KAREL_SIZE; break; 
			case WEST_DIR:  nx -= KAREL_SIZE; break; 
		} 
		println(x + "->" + nx);
		println(y + "->" + ny);
		if (isKarelOnScreen(nx, ny)) { 
			x = nx; 
			y = ny; 
			karel.setLocation(x, y); 
		} 
	}


	private void turnLeft() { 
		switch (dir) { 
		case NORTH_DIR: 
			dir = WEST_DIR; 
			karel.setImage("KarelWest.jpg"); 
			break; 
		case EAST_DIR: 
			dir = NORTH_DIR; 
			karel.setImage("KarelNorth.jpg"); 
			break; 
		case SOUTH_DIR: 
			dir = EAST_DIR; 
			karel.setImage("KarelEast.jpg"); 
			break; 
		case WEST_DIR: 
			dir = SOUTH_DIR; 
			karel.setImage("KarelSouth.jpg"); 
			break; 
		} 
		karel.setSize(KAREL_SIZE, KAREL_SIZE);
	} 

	private boolean isKarelOnScreen(double x, double y) { 
		return (x >= 0) && (y >= 0) 
			&& (x + KAREL_SIZE <= getWidth()) 
			&& (y + KAREL_SIZE <= getHeight()); 
	} 

	private void initControlStrip() { 
		add(new JButton("move"), SOUTH); 
		add(new JButton("turnLeft"), SOUTH); 
	} 

	private GImage karel; 
	private double x; 
	private double y; 
	private int dir; 

	private static final int KAREL_SIZE = 64; 
	private static final int NORTH_DIR = 0; 
	private static final int EAST_DIR = 1; 
	private static final int SOUTH_DIR = 2;
	private static final int WEST_DIR = 3;
	
	public static final int APPLICATION_HEIGHT = 300;
	public static final int APPLICATION_WIDTH = 320;
}

