import java.util.*;

public class CaseInsensitiveMap {
	/* The actual map.  Keys are stored in lower-case. */
	private Map<String, String> map = new HashMap<String, String>();
	
	/**
	 * Inserts a new key/value pair into the map.  If the key already exists
	 * in the map, the old key/value pair is overwritten.
	 * 
	 * @param key The key to insert.
	 * @param value The value associated with the key.
	 */
	public void put(String key, String value) {
		map.put(key.toLowerCase(), value);
	}
	
	/**
	 * Returns the value associated with the given key, returning null if the
	 * key doesn't exist.
	 * 
	 * @param key The key to look up.
	 * @return The associated value.
	 */
	public String get(String key) {
		return map.get(key.toLowerCase());
	}
	
	/**
	 * Returns whether the given key exists in the map.
	 * 
	 * @param key The key to look up.
	 * @return Whether it exists in the map.
	 */
	public boolean containsKey(String key) {
		return map.containsKey(key.toLowerCase());
	}
}
