import acm.program.*;
import acm.graphics.*;

public class ColorInversion extends GraphicsProgram {
	public void run() {
		add(invertColors(new GImage("dark-side-of-the-moon.jpg")));
	}
	
	private GImage invertColors(GImage toInvert) {
		/* Get the original array of pixels. */
		int[][] pixels = toInvert.getPixelArray();
		
		/* Determine the number of rows and columns.  Each row of the image is
		 * represented by a row in the array.
		 */
		int numRows = pixels.length;
		int numCols = pixels[0].length;
		
		for (int row = 0; row < numRows; row++) {
			for (int col = 0; col < numCols; col++) {
				/* Determine the new RGB values from the old. */
				int r = 255 - GImage.getRed(pixels[row][col]);
				int g = 255 - GImage.getGreen(pixels[row][col]);
				int b = 255 - GImage.getBlue(pixels[row][col]);
				
				/* Convert this back to a pixel. */
				pixels[row][col] = GImage.createRGBPixel(r, g, b);
			}
		}
		
		/* Create a new image from this pixel array. */
		return new GImage(pixels);
	}
}
