import acm.program.*;

public class ParseIntWithCommas extends ConsoleProgram {
	public void run() {
		println(parseIntWithCommas("1,000"));
		println(parseIntWithCommas("137"));
		println(parseIntWithCommas("137,222,111"));
	}
	
	/**
	 * Given a string representation of an integer with commas inserted
	 * appropriately, returns the integer value represented by that
	 * integer.  It's assumed that the integer is a legal integer in the
	 * range of representable integers.
	 * 
	 * @param number The string to parse.
	 * @return Its numeric value.
	 */
	private int parseIntWithCommas(String number) {
		/* Build up a string formed by stripping out all of the commas. */
		String justDigits = "";
		
		for (int i = 0; i < number.length(); i++) {
			char current = number.charAt(i);
			if (Character.isDigit(current))
				justDigits += current;
		}
		
		/* Use Integer.parseInt to parse it. */
		return Integer.parseInt(justDigits);
	}
}
