import acm.program.*;
import java.util.*;

public class ProbablyUnimportantPages extends ConsoleProgram {
	public void run() {
		Map<String, List<String>> links = new HashMap<String, List<String>>();
		
		links.put("A",Arrays.asList(new String[] {"A", "B"}));
		links.put("B",Arrays.asList(new String[] {"C"}));
		links.put("C",Arrays.asList(new String[] {"A", "B"}));
		links.put("D",Arrays.asList(new String[] {"A", "B", "C"}));
		links.put("E",Arrays.asList(new String[] {}));
		
		for (String boring: findUnimportantPages(links))
			println(boring);
	}
	
	private Set<String> findUnimportantPages(Map<String, List<String>> links) {
		/* Begin by building up a set of all of the pages. */
		Set<String> result = new HashSet<String>();
		for (String page: links.keySet())
			result.add(page);
		
		/* Now, remove all pages from this set that have links to them. */
		for (String page: links.keySet()) {
			for (String linkedTo: links.get(page)) {
				result.remove(linkedTo);
			}
		}
		
		/* Hand back all pages that weren't linked to. */
		return result;
	}
}
