/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.AddVMInstallWizard;
import org.eclipse.jdt.internal.debug.ui.jres.EditVMInstallWizard;
import org.eclipse.jdt.internal.debug.ui.jres.IAddVMDialogRequestor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.MacVMSearch;
import org.eclipse.jdt.internal.debug.ui.jres.VMDetailsDialog;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class InstalledJREsBlock
implements IAddVMDialogRequestor,
ISelectionProvider {
    private Composite fControl;
    private List fVMs = new ArrayList();
    private CheckboxTableViewer fVMList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private Button fCopyButton;
    private Button fSearchButton;
    private int fSortColumn = 0;
    private ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;
    private static String fgLastUsedID;
    public static final String MACOSX_VM_TYPE_ID = "org.eclipse.jdt.internal.launching.macosx.MacOSXType";

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.fVMList.getCheckedElements());
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object jre = ((IStructuredSelection)selection).getFirstElement();
            if (jre == null) {
                this.fVMList.setCheckedElements(new Object[0]);
            } else {
                this.fVMList.setCheckedElements(new Object[]{jre});
                this.fVMList.reveal(jre);
            }
            this.fireSelectionChanged();
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent;
        Font font = ancestor.getFont();
        this.fControl = parent = SWTFactory.createComposite((Composite)ancestor, (Font)font, (int)2, (int)1, (int)1808);
        SWTFactory.createLabel((Composite)parent, (String)JREMessages.InstalledJREsBlock_15, (int)2);
        this.fTable = new Table(parent, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.fTable.setLayoutData((Object)gd);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.fTable, 0);
        column.setText(JREMessages.InstalledJREsBlock_0);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledJREsBlock.this.sortByName();
            }
        });
        int defaultwidth = 117;
        column.setWidth(defaultwidth);
        column = new TableColumn(this.fTable, 0);
        column.setText(JREMessages.InstalledJREsBlock_1);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledJREsBlock.this.sortByLocation();
            }
        });
        column.setWidth(defaultwidth);
        column = new TableColumn(this.fTable, 0);
        column.setText(JREMessages.InstalledJREsBlock_2);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledJREsBlock.this.sortByType();
            }
        });
        column.setWidth(defaultwidth);
        this.fVMList = new CheckboxTableViewer(this.fTable);
        this.fVMList.setLabelProvider((IBaseLabelProvider)new VMLabelProvider());
        this.fVMList.setContentProvider((IContentProvider)new JREsContentProvider());
        this.sortByName();
        this.fVMList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledJREsBlock.this.enableButtons();
            }
        });
        this.fVMList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InstalledJREsBlock.this.setCheckedJRE((IVMInstall)event.getElement());
                } else {
                    InstalledJREsBlock.this.setCheckedJRE(null);
                }
            }
        });
        this.fVMList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!InstalledJREsBlock.this.fVMList.getSelection().isEmpty()) {
                    InstalledJREsBlock.this.editVM();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && InstalledJREsBlock.this.fRemoveButton.isEnabled()) {
                    InstalledJREsBlock.this.removeVMs();
                }
            }
        });
        Composite buttons = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)2, (int)0, (int)0);
        this.fAddButton = SWTFactory.createPushButton((Composite)buttons, (String)JREMessages.InstalledJREsBlock_3, null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJREsBlock.this.addVM();
            }
        });
        this.fEditButton = SWTFactory.createPushButton((Composite)buttons, (String)JREMessages.InstalledJREsBlock_4, null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJREsBlock.this.editVM();
            }
        });
        this.fCopyButton = SWTFactory.createPushButton((Composite)buttons, (String)JREMessages.InstalledJREsBlock_16, null);
        this.fCopyButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJREsBlock.this.copyVM();
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton((Composite)buttons, (String)JREMessages.InstalledJREsBlock_5, null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJREsBlock.this.removeVMs();
            }
        });
        SWTFactory.createVerticalSpacer((Composite)parent, (int)1);
        this.fSearchButton = SWTFactory.createPushButton((Composite)buttons, (String)JREMessages.InstalledJREsBlock_6, null);
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledJREsBlock.this.search();
            }
        });
        this.fillWithWorkspaceJREs();
        this.enableButtons();
        this.fAddButton.setEnabled(JavaRuntime.getVMInstallTypes().length > 0);
    }

    protected void copyVM() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        Iterator it = selection.iterator();
        ArrayList<VMStandin> newEntries = new ArrayList<VMStandin>();
        while (it.hasNext()) {
            IVMInstall selectedVM = (IVMInstall)it.next();
            VMStandin standin = new VMStandin(selectedVM, this.createUniqueId(selectedVM.getVMInstallType()));
            standin.setName(this.generateName(selectedVM.getName()));
            EditVMInstallWizard wizard = new EditVMInstallWizard(standin, this.fVMs.toArray(new IVMInstall[this.fVMs.size()]));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            int dialogResult = dialog.open();
            if (dialogResult == 0) {
                VMStandin result = wizard.getResult();
                if (result == null) continue;
                newEntries.add(result);
                continue;
            }
            if (dialogResult == 1) break;
        }
        if (newEntries.size() > 0) {
            this.fVMs.addAll(newEntries);
            this.fVMList.refresh();
            this.fVMList.setSelection((ISelection)new StructuredSelection(newEntries.toArray()));
        } else {
            this.fVMList.setSelection((ISelection)selection);
        }
    }

    public String generateName(String name) {
        if (!this.isDuplicateName(name)) {
            return name;
        }
        if (name.matches(".*\\(\\d*\\)")) {
            int start = name.lastIndexOf(40);
            int end = name.lastIndexOf(41);
            String stringInt = name.substring(start + 1, end);
            int numericValue = Integer.parseInt(stringInt);
            String newName = String.valueOf(name.substring(0, start + 1)) + (numericValue + 1) + ")";
            return this.generateName(newName);
        }
        return this.generateName(String.valueOf(name) + " (1)");
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    private void sortByType() {
        this.fVMList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IVMInstall && e2 instanceof IVMInstall) {
                    String rightType;
                    IVMInstall left = (IVMInstall)e1;
                    IVMInstall right = (IVMInstall)e2;
                    String leftType = left.getVMInstallType().getName();
                    int res = leftType.compareToIgnoreCase(rightType = right.getVMInstallType().getName());
                    if (res != 0) {
                        return res;
                    }
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    private void sortByName() {
        this.fVMList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IVMInstall && e2 instanceof IVMInstall) {
                    IVMInstall left = (IVMInstall)e1;
                    IVMInstall right = (IVMInstall)e2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    private void sortByLocation() {
        this.fVMList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IVMInstall && e2 instanceof IVMInstall) {
                    IVMInstall left = (IVMInstall)e1;
                    IVMInstall right = (IVMInstall)e2;
                    return left.getInstallLocation().getAbsolutePath().compareToIgnoreCase(right.getInstallLocation().getAbsolutePath());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 2;
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1);
        this.fCopyButton.setEnabled(selectionCount > 0);
        if (selectionCount > 0 && selectionCount < this.fVMList.getTable().getItemCount()) {
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                IVMInstall install = (IVMInstall)iterator.next();
                if (!this.isContributed(install)) continue;
                this.fRemoveButton.setEnabled(false);
                return;
            }
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    private boolean isContributed(IVMInstall install) {
        return JavaRuntime.isContributedVMInstall((String)install.getId());
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setJREs(IVMInstall[] vms) {
        this.fVMs.clear();
        int i = 0;
        while (i < vms.length) {
            this.fVMs.add(vms[i]);
            ++i;
        }
        this.fVMList.setInput((Object)this.fVMs);
        this.fVMList.refresh();
    }

    public IVMInstall[] getJREs() {
        return this.fVMs.toArray(new IVMInstall[this.fVMs.size()]);
    }

    private void addVM() {
        VMStandin result;
        AddVMInstallWizard wizard = new AddVMInstallWizard(this.fVMs.toArray(new IVMInstall[this.fVMs.size()]));
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0 && (result = wizard.getResult()) != null) {
            this.fVMs.add(result);
            this.fVMList.refresh();
            this.fVMList.setSelection((ISelection)new StructuredSelection((Object)result));
        }
    }

    public void vmAdded(IVMInstall vm) {
        this.fVMs.add(vm);
        this.fVMList.refresh();
    }

    public boolean isDuplicateName(String name) {
        int i = 0;
        while (i < this.fVMs.size()) {
            IVMInstall vm = (IVMInstall)this.fVMs.get(i);
            if (vm.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void editVM() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        VMStandin vm = (VMStandin)selection.getFirstElement();
        if (vm == null) {
            return;
        }
        if (this.isContributed((IVMInstall)vm)) {
            VMDetailsDialog dialog = new VMDetailsDialog(this.getShell(), (IVMInstall)vm);
            dialog.open();
        } else {
            VMStandin result;
            EditVMInstallWizard wizard = new EditVMInstallWizard(vm, this.fVMs.toArray(new IVMInstall[this.fVMs.size()]));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            if (dialog.open() == 0 && (result = wizard.getResult()) != null) {
                int index = this.fVMs.indexOf(vm);
                this.fVMs.remove(index);
                this.fVMs.add(index, result);
                this.fVMList.refresh();
                this.fVMList.setSelection((ISelection)new StructuredSelection((Object)result));
            }
        }
    }

    private void removeVMs() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        IVMInstall[] vms = new IVMInstall[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            vms[i] = (IVMInstall)iter.next();
            ++i;
        }
        this.removeJREs(vms);
    }

    public void removeJREs(IVMInstall[] vms) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        int i = 0;
        while (i < vms.length) {
            this.fVMs.remove(vms[i]);
            ++i;
        }
        this.fVMList.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            IVMInstall[] installs = this.getJREs();
            if (curr.size() == 0 && installs.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)installs[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    protected void search() {
        if ("macosx".equals(Platform.getOS())) {
            this.doMacSearch();
            return;
        }
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setMessage(JREMessages.InstalledJREsBlock_9);
        dialog.setText(JREMessages.InstalledJREsBlock_10);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        final HashSet<File> exstingLocations = new HashSet<File>();
        Iterator iter = this.fVMs.iterator();
        while (iter.hasNext()) {
            exstingLocations.add(((IVMInstall)iter.next()).getInstallLocation());
        }
        final File rootDir = new File(path);
        final ArrayList locations = new ArrayList();
        final ArrayList types = new ArrayList();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(JREMessages.InstalledJREsBlock_11, -1);
                InstalledJREsBlock.this.search(rootDir, locations, types, exstingLocations, monitor);
                monitor.done();
            }
        };
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell()){

                protected void createCancelButton(Composite parent) {
                    this.cancel = this.createButton(parent, 1, IDialogConstants.STOP_LABEL, true);
                    if (this.arrowCursor == null) {
                        this.arrowCursor = new Cursor((Device)this.cancel.getDisplay(), 0);
                    }
                    this.cancel.setCursor(this.arrowCursor);
                    this.setOperationCancelButtonEnabled(this.enableCancelButton);
                }
            };
            progress.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (locations.isEmpty()) {
            String messagePath = path.replaceAll("&", "&&");
            MessageDialog.openInformation((Shell)this.getShell(), (String)JREMessages.InstalledJREsBlock_12, (String)MessageFormat.format((String)JREMessages.InstalledJREsBlock_13, (Object[])new String[]{messagePath}));
        } else {
            iter = locations.iterator();
            Iterator iter2 = types.iterator();
            while (iter.hasNext()) {
                File location = (File)iter.next();
                IVMInstallType type = (IVMInstallType)iter2.next();
                VMStandin vm = new VMStandin(type, this.createUniqueId(type));
                String name = location.getName();
                String nameCopy = new String(name);
                int i = 1;
                while (this.isDuplicateName(nameCopy)) {
                    nameCopy = String.valueOf(name) + '(' + i++ + ')';
                }
                vm.setName(nameCopy);
                vm.setInstallLocation(location);
                if (type instanceof AbstractVMInstallType) {
                    AbstractVMInstallType abs = (AbstractVMInstallType)type;
                    vm.setJavadocLocation(abs.getDefaultJavadocLocation(location));
                    vm.setVMArgs(abs.getDefaultVMArguments(location));
                }
                this.vmAdded((IVMInstall)vm);
            }
        }
    }

    private void doMacSearch() {
        final ArrayList added = new ArrayList();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                HashSet<String> exists = new HashSet<String>();
                Iterator iterator = InstalledJREsBlock.this.fVMs.iterator();
                while (iterator.hasNext()) {
                    IVMInstall vm = (IVMInstall)iterator.next();
                    exists.add(vm.getId());
                }
                VMStandin[] standins = new MacVMSearch().search(monitor);
                int i = 0;
                while (i < standins.length) {
                    if (!exists.contains(standins[i].getId())) {
                        added.add(standins[i]);
                    }
                    ++i;
                }
                monitor.done();
            }
        };
        try {
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getShell());
            progress.run(true, true, r);
        }
        catch (InvocationTargetException e) {
            JDIDebugUIPlugin.log(e);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        Iterator iterator = added.iterator();
        while (iterator.hasNext()) {
            IVMInstall vm = (IVMInstall)iterator.next();
            this.vmAdded(vm);
        }
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    private String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null || id.equals(fgLastUsedID)) {
        }
        fgLastUsedID = id;
        return id;
    }

    protected void search(File directory, List found, List types, Set ignore, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String[] names = directory.list();
        if (names == null) {
            return;
        }
        ArrayList<File> subDirs = new ArrayList<File>();
        int i = 0;
        while (i < names.length) {
            if (monitor.isCanceled()) {
                return;
            }
            File file = new File(directory, names[i]);
            try {
                monitor.subTask(MessageFormat.format((String)JREMessages.InstalledJREsBlock_14, (Object[])new String[]{Integer.toString(found.size()), file.getCanonicalPath().replaceAll("&", "&&")}));
            }
            catch (IOException iOException) {}
            IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
            if (file.isDirectory() && !ignore.contains(file)) {
                boolean validLocation = false;
                int j = 0;
                while (j < vmTypes.length) {
                    if (monitor.isCanceled()) {
                        return;
                    }
                    IVMInstallType type = vmTypes[j];
                    IStatus status = type.validateInstallLocation(file);
                    if (status.isOK()) {
                        found.add(file);
                        types.add(type);
                        validLocation = true;
                        break;
                    }
                    ++j;
                }
                if (!validLocation) {
                    subDirs.add(file);
                }
            }
            ++i;
        }
        while (!subDirs.isEmpty()) {
            File subDir = (File)subDirs.remove(0);
            this.search(subDir, found, types, ignore, monitor);
            if (!monitor.isCanceled()) continue;
            return;
        }
    }

    public void setCheckedJRE(IVMInstall vm) {
        if (vm == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)vm));
        }
    }

    public IVMInstall getCheckedJRE() {
        Object[] objects = this.fVMList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (IVMInstall)objects[0];
    }

    public void saveColumnSettings(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            settings.put(String.valueOf(qualifier) + ".columnWidth" + i, this.fTable.getColumn(i).getWidth());
            ++i;
        }
        settings.put(String.valueOf(qualifier) + ".sortColumn", this.fSortColumn);
    }

    public void restoreColumnSettings(IDialogSettings settings, String qualifier) {
        this.fVMList.getTable().layout(true);
        this.restoreColumnWidths(settings, qualifier);
        try {
            this.fSortColumn = settings.getInt(String.valueOf(qualifier) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByLocation();
                break;
            }
            case 3: {
                this.sortByType();
            }
        }
    }

    private void restoreColumnWidths(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = settings.getInt(String.valueOf(qualifier) + ".columnWidth" + i);
            }
            catch (NumberFormatException numberFormatException) {}
            if (width <= 0 || i == this.fTable.getColumnCount() - 1) {
                this.fTable.getColumn(i).pack();
            } else {
                this.fTable.getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    protected void fillWithWorkspaceJREs() {
        ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                standins.add(new VMStandin(install));
                ++j;
            }
            ++i;
        }
        this.setJREs(standins.toArray(new IVMInstall[standins.size()]));
    }

    class JREsContentProvider
    implements IStructuredContentProvider {
        JREsContentProvider() {
        }

        public Object[] getElements(Object input) {
            return InstalledJREsBlock.this.fVMs.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    class VMLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        VMLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IVMInstall) {
                IVMInstall vm = (IVMInstall)element;
                switch (columnIndex) {
                    case 0: {
                        if (InstalledJREsBlock.this.isContributed(vm)) {
                            return MessageFormat.format((String)JREMessages.InstalledJREsBlock_19, (Object[])new String[]{vm.getName()});
                        }
                        return vm.getName();
                    }
                    case 1: {
                        return vm.getInstallLocation().getAbsolutePath();
                    }
                    case 2: {
                        return vm.getVMInstallType().getName();
                    }
                }
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.library_obj.gif");
            }
            return null;
        }
    }
}

