/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.ant;

import com.sshtools.ant.SshSubTask;
import com.sshtools.j2ssh.SftpClient;
import com.sshtools.j2ssh.SshClient;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.sftp.SftpFileOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Sftp
extends SshSubTask {
    protected static final int SEND_FILES = 0;
    protected static final int GET_FILES = 1;
    protected static final int DEL_FILES = 2;
    protected static final int MK_DIR = 4;
    protected static final int CHMOD = 5;
    protected static final String[] ACTION_STRS = new String[]{"Sending", "Getting", "Deleting", "Listing", "Making directory", "chmod"};
    protected static final String[] COMPLETED_ACTION_STRS = new String[]{"Sent", "Retrieved", "Deleted", "Listed", "Created directory", "Mode changed"};
    private String remotedir = ".";
    private boolean verbose = false;
    private boolean newerOnly = false;
    private int action = 0;
    private Vector filesets = new Vector();
    private Vector dirCache = new Vector();
    private int transferred = 0;
    private String remoteFileSep = "/";
    private boolean skipFailedTransfers = false;
    private int skipped = 0;
    private boolean ignoreNoncriticalErrors = false;
    private String chmod = "777";
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setRemotedir(String remotedir) {
        this.remotedir = remotedir;
    }

    public void setNewer(boolean newer) {
        this.newerOnly = newer;
    }

    public void setDepends(boolean depends) {
        this.newerOnly = depends;
    }

    public void setChmod(String theMode) {
        this.chmod = theMode;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void setAction(Action action) throws BuildException {
        this.action = action.getAction();
    }

    public void setSkipFailedTransfers(boolean skipFailedTransfers) {
        this.skipFailedTransfers = skipFailedTransfers;
    }

    public void setIgnoreNoncriticalErrors(boolean ignoreNoncriticalErrors) {
        this.ignoreNoncriticalErrors = ignoreNoncriticalErrors;
    }

    protected void checkConfiguration() throws BuildException {
        if (this.action == 4 && this.remotedir == null) {
            throw new BuildException("remotedir attribute must be set for mkdir action!");
        }
        if (this.action == 5 && this.chmod == null) {
            throw new BuildException("chmod attribute must be set for chmod action!");
        }
    }

    protected int transferFiles(SftpClient sftp, FileSet fs) throws IOException, BuildException {
        DirectoryScanner ds;
        if (this.action == 0) {
            ds = fs.getDirectoryScanner(this.parent.getProject());
        } else {
            ds = new SftpDirectoryScanner(sftp);
            fs.setupDirectoryScanner((FileScanner)ds, this.parent.getProject());
            ds.scan();
        }
        String[] dsfiles = ds.getIncludedFiles();
        String dir = null;
        if (ds.getBasedir() == null && (this.action == 0 || this.action == 1)) {
            throw new BuildException("the dir attribute must be set for send and get actions");
        }
        if (this.action == 0 || this.action == 1) {
            dir = ds.getBasedir().getAbsolutePath();
        }
        BufferedWriter bw = null;
        try {
            int i = 0;
            while (i < dsfiles.length) {
                switch (this.action) {
                    case 0: {
                        this.sendFile(sftp, dir, dsfiles[i]);
                        break;
                    }
                    case 1: {
                        this.getFile(sftp, dir, dsfiles[i]);
                        break;
                    }
                    case 2: {
                        this.delFile(sftp, dsfiles[i]);
                        break;
                    }
                    case 5: {
                        this.chmod(sftp, dsfiles[i]);
                        ++this.transferred;
                        break;
                    }
                    default: {
                        throw new BuildException("unknown ftp action " + this.action);
                    }
                }
                ++i;
            }
        }
        finally {
            if (bw != null) {
                bw.close();
            }
        }
        return dsfiles.length;
    }

    protected void transferFiles(SftpClient sftp) throws IOException, BuildException {
        this.transferred = 0;
        this.skipped = 0;
        if (this.filesets.size() == 0) {
            throw new BuildException("at least one fileset must be specified.");
        }
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            if (fs != null) {
                this.transferFiles(sftp, fs);
            }
            ++i;
        }
        this.log(String.valueOf(this.transferred) + " files " + COMPLETED_ACTION_STRS[this.action]);
        if (this.skipped != 0) {
            this.log(String.valueOf(this.skipped) + " files were not successfully " + COMPLETED_ACTION_STRS[this.action]);
        }
    }

    protected String resolveFile(String file) {
        return file.replace(System.getProperty("file.separator").charAt(0), this.remoteFileSep.charAt(0));
    }

    protected void createParents(SftpClient sftp, String filename) throws IOException, BuildException {
        String dirname;
        Vector<File> parents = new Vector<File>();
        File dir = new File(filename);
        while ((dirname = dir.getParent()) != null) {
            dir = new File(dirname);
            parents.addElement(dir);
        }
        int i = parents.size() - 1;
        while (i >= 0) {
            dir = (File)parents.elementAt(i);
            if (!this.dirCache.contains(dir)) {
                this.log("creating remote directory " + this.resolveFile(dir.getPath()), 3);
                try {
                    sftp.mkdir(this.resolveFile(dir.getPath()));
                }
                catch (IOException iOException) {}
                this.dirCache.addElement(dir);
            }
            --i;
        }
    }

    protected boolean isUpToDate(SftpClient sftp, File localFile, String remoteFile) throws IOException, BuildException {
        try {
            this.log("Checking date for " + remoteFile, 3);
            FileAttributes attrs = sftp.stat(remoteFile);
            long remoteTimestamp = attrs.getModifiedTime().longValue() * 1000L;
            long localTimestamp = localFile.lastModified();
            if (this.action == 0) {
                return remoteTimestamp > localTimestamp;
            }
            return localTimestamp > remoteTimestamp;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendFile(SftpClient sftp, String dir, String filename) throws IOException, BuildException {
        String remotefile;
        File file;
        SftpFileOutputStream out;
        InputStream instream;
        block26: {
            instream = null;
            out = null;
            file = this.parent.getProject().resolveFile(new File(dir, filename).getPath());
            remotefile = this.resolveFile(filename);
            if (!this.newerOnly || !this.isUpToDate(sftp, file, remotefile)) break block26;
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out == null) return;
                out.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        try {
            try {
                if (this.verbose) {
                    this.log("transferring " + file.getAbsolutePath() + " to " + this.remotedir + remotefile);
                }
                instream = new BufferedInputStream(new FileInputStream(file));
                this.createParents(sftp, filename);
                sftp.put(file.getAbsolutePath(), remotefile);
                sftp.chmod(Integer.parseInt(this.chmod, 8), remotefile);
                this.log("File " + file.getAbsolutePath() + " copied to " + this.parent.host, 3);
                ++this.transferred;
            }
            catch (IOException ex1) {
                String s = "Could not put file: " + ex1.getMessage();
                if (!this.skipFailedTransfers) throw new BuildException(s);
                this.log(s, 1);
                ++this.skipped;
                try {
                    if (instream != null) {
                        instream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (out == null) return;
                    out.close();
                    return;
                }
                catch (IOException iOException) {}
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                if (instream != null) {
                    instream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (instream != null) {
                instream.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (out == null) return;
            out.close();
            return;
        }
        catch (IOException iOException) {}
    }

    protected void delFile(SftpClient sftp, String filename) throws IOException, BuildException {
        if (this.verbose) {
            this.log("deleting " + filename);
        }
        try {
            String remotefile = this.resolveFile(filename);
            sftp.rm(remotefile);
            this.log("File " + filename + " deleted from " + this.parent.host, 3);
            ++this.transferred;
        }
        catch (IOException ex) {
            String s = "could not delete file: " + ex.getMessage();
            if (this.skipFailedTransfers) {
                this.log(s, 1);
                ++this.skipped;
            }
            throw new BuildException(s);
        }
    }

    protected void chmod(SftpClient sftp, String filename) throws IOException, BuildException {
        sftp.chmod(Integer.parseInt(this.chmod, 8), this.resolveFile(filename));
    }

    protected void getFile(SftpClient sftp, String dir, String filename) throws IOException, BuildException {
        try {
            File pdir;
            String localfile = filename;
            if (localfile.indexOf("/") >= 0) {
                localfile = localfile.substring(filename.lastIndexOf("/"));
            }
            File file = this.parent.getProject().resolveFile(new File(dir, localfile).getAbsolutePath());
            this.log(dir);
            this.log(filename);
            this.log(file.getAbsolutePath());
            if (this.newerOnly && this.isUpToDate(sftp, file, this.resolveFile(filename))) {
                return;
            }
            if (this.verbose) {
                this.log("transferring " + filename + " to " + file.getAbsolutePath());
            }
            if (!(pdir = this.fileUtils.getParentFile(file)).exists()) {
                pdir.mkdirs();
            }
            sftp.get(filename, file.getAbsolutePath());
            if (this.verbose) {
                this.log("File " + file.getAbsolutePath() + " copied from " + this.parent.host);
            }
            FileAttributes attrs = sftp.stat(filename);
            file.setLastModified(attrs.getModifiedTime().longValue() * 1000L);
            ++this.transferred;
        }
        catch (IOException ioe) {
            String s = "could not get file: " + ioe.getMessage();
            if (this.skipFailedTransfers) {
                this.log(s, 1);
                ++this.skipped;
            }
            throw new BuildException(s);
        }
    }

    protected void makeRemoteDir(SftpClient sftp, String dir) throws BuildException {
        if (this.verbose) {
            this.log("creating directory: " + dir);
        }
        try {
            sftp.mkdir(dir);
        }
        catch (IOException ex) {
            this.log(ex.getMessage());
        }
    }

    public void execute(SshClient ssh) throws BuildException {
        try {
            Integer.parseInt(this.chmod, 8);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BuildException("chmod attribute format is incorrect, use octal number format i.e 0777");
        }
        this.executeSFTPTask(ssh);
    }

    protected void executeSFTPTask(SshClient ssh) throws BuildException {
        SftpClient sftp = null;
        try {
            try {
                sftp = ssh.openSftpClient();
                if (this.action == 4) {
                    this.makeRemoteDir(sftp, this.remotedir);
                } else {
                    if (this.remotedir.trim().length() > 0) {
                        this.log("Setting the remote directory ");
                        sftp.cd(this.remotedir);
                    }
                    this.remotedir = sftp.pwd();
                    this.log("Remote directory is " + this.remotedir);
                    if (!this.remotedir.endsWith("/")) {
                        this.remotedir = String.valueOf(this.remotedir) + "/";
                    }
                    this.log(String.valueOf(ACTION_STRS[this.action]) + " files");
                    this.transferFiles(sftp);
                }
            }
            catch (IOException ex) {
                throw new BuildException("error during SFTP transfer: " + ex);
            }
        }
        catch (Throwable throwable) {
            if (sftp != null && !sftp.isClosed()) {
                try {
                    this.log("Quiting SFTP", 3);
                    sftp.quit();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (sftp != null && !sftp.isClosed()) {
            try {
                this.log("Quiting SFTP", 3);
                sftp.quit();
            }
            catch (IOException iOException) {}
        }
    }

    public static class Action
    extends EnumeratedAttribute {
        private static final String[] validActions = new String[]{"send", "put", "recv", "get", "del", "delete", "list", "mkdir", "chmod"};

        public String[] getValues() {
            return validActions;
        }

        public int getAction() {
            String actionL = this.getValue().toLowerCase(Locale.US);
            if (actionL.equals("send") || actionL.equals("put")) {
                return 0;
            }
            if (actionL.equals("recv") || actionL.equals("get")) {
                return 1;
            }
            if (actionL.equals("del") || actionL.equals("delete")) {
                return 2;
            }
            if (actionL.equals("chmod")) {
                return 5;
            }
            if (actionL.equals("mkdir")) {
                return 4;
            }
            return 0;
        }
    }

    protected class SftpDirectoryScanner
    extends DirectoryScanner {
        protected SftpClient sftp = null;

        public SftpDirectoryScanner(SftpClient sftp2) {
            this.sftp = sftp2;
        }

        public void scan() {
            if (this.includes == null) {
                this.includes = new String[1];
                this.includes[0] = "**";
            }
            if (this.excludes == null) {
                this.excludes = new String[0];
            }
            this.filesIncluded = new Vector();
            this.filesNotIncluded = new Vector();
            this.filesExcluded = new Vector();
            this.dirsIncluded = new Vector();
            this.dirsNotIncluded = new Vector();
            this.dirsExcluded = new Vector();
            this.scandir(Sftp.this.remotedir, true);
        }

        protected void scandir(String dir, boolean fast) {
            try {
                List children = this.sftp.ls(dir);
                if (!dir.endsWith("/")) {
                    dir = String.valueOf(dir) + "/";
                }
                for (SftpFile file : children) {
                    String name;
                    if (file.getFilename().equals(".") || file.getFilename().equals("..")) continue;
                    if (file.isDirectory()) {
                        name = String.valueOf(dir) + file.getFilename();
                        if (this.isIncluded(name)) {
                            if (!this.isExcluded(name)) {
                                this.dirsIncluded.addElement(name);
                                if (fast) {
                                    this.scandir(String.valueOf(dir) + file.getFilename(), fast);
                                }
                            } else {
                                this.dirsExcluded.addElement(name);
                                if (fast && this.couldHoldIncluded(name)) {
                                    this.scandir(String.valueOf(dir) + file.getFilename(), fast);
                                }
                            }
                        } else {
                            this.dirsNotIncluded.addElement(name);
                            if (fast && this.couldHoldIncluded(name)) {
                                this.scandir(String.valueOf(dir) + file.getFilename(), fast);
                            }
                        }
                        if (fast) continue;
                        this.scandir(String.valueOf(dir) + file.getFilename(), fast);
                        continue;
                    }
                    if (!file.isFile()) continue;
                    name = String.valueOf(dir) + file.getFilename();
                    if (this.isIncluded(name)) {
                        if (!this.isExcluded(name)) {
                            this.filesIncluded.addElement(name);
                            continue;
                        }
                        this.filesExcluded.addElement(name);
                        continue;
                    }
                    this.filesNotIncluded.addElement(name);
                }
            }
            catch (IOException e) {
                throw new BuildException("Error while communicating with SFTP ", (Throwable)e);
            }
        }
    }
}

