/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.configuration;

import com.sshtools.common.automate.AutomationConfiguration;
import com.sshtools.common.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.configuration.ConfigurationContext;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlConfigurationContext
implements ConfigurationContext {
    private static Log log = LogFactory.getLog(XmlConfigurationContext.class);
    HashMap configurations = new HashMap();
    String apiResource = "sshtools.xml";
    String automationResource = "automation.xml";
    private boolean failOnError = false;

    public void setAPIConfigurationResource(String apiResource) {
        this.apiResource = apiResource;
    }

    public void setAutomationConfigurationResource(String automationResource) {
        this.automationResource = automationResource;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void initialize() throws ConfigurationException {
        if (this.apiResource != null) {
            try {
                SshAPIConfiguration x = new SshAPIConfiguration(ConfigurationLoader.loadFile(this.apiResource));
                this.configurations.put(com.sshtools.j2ssh.configuration.SshAPIConfiguration.class, x);
            }
            catch (Exception ex) {
                if (this.failOnError) {
                    throw new ConfigurationException(ex.getMessage());
                }
                log.info((Object)(String.valueOf(this.apiResource) + " could not be found: " + ex.getMessage()));
            }
        }
        if (this.automationResource != null) {
            try {
                AutomationConfiguration y = new AutomationConfiguration(ConfigurationLoader.loadFile(this.automationResource));
                this.configurations.put(AutomationConfiguration.class, y);
            }
            catch (Exception ex) {
                if (this.failOnError) {
                    throw new ConfigurationException(ex.getMessage());
                }
                log.info((Object)(String.valueOf(this.automationResource) + " could not be found: " + ex.getMessage()));
            }
        }
    }

    public boolean isConfigurationAvailable(Class cls) {
        return this.configurations.containsKey(cls);
    }

    public Object getConfiguration(Class cls) throws ConfigurationException {
        if (this.configurations.containsKey(cls)) {
            return this.configurations.get(cls);
        }
        throw new ConfigurationException(String.valueOf(cls.getName()) + " configuration not available");
    }
}

