/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.hosts;

import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractHostKeyVerification
extends DefaultHandler
implements HostKeyVerification {
    private static String defaultHostFile;
    private static Log log;
    private List deniedHosts;
    private Map allowedHosts;
    private String hostFile;
    private boolean hostFileWriteable;
    private boolean expectEndElement;
    private String currentElement;

    static {
        log = LogFactory.getLog(HostKeyVerification.class);
        log.info((Object)"Determining default host file");
        defaultHostFile = ConfigurationLoader.getConfigurationDirectory();
        if (defaultHostFile == null) {
            log.info((Object)"No configuration location, persistence of host keys will be disabled.");
        } else {
            defaultHostFile = String.valueOf(defaultHostFile) + "hosts.xml";
            log.info((Object)("Defaulting host file to " + defaultHostFile));
        }
    }

    public AbstractHostKeyVerification() throws InvalidHostFileException {
        this(defaultHostFile);
        this.hostFile = defaultHostFile;
    }

    /*
     * Exception decompiling
     */
    public AbstractHostKeyVerification(String hostFileName) throws InvalidHostFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String qname, Attributes attrs) throws SAXException {
        if (this.currentElement == null) {
            if (!qname.equals("HostAuthorizations")) throw new SAXException("Unexpected document element!");
            this.allowedHosts.clear();
            this.deniedHosts.clear();
            this.currentElement = qname;
            return;
        } else {
            if (!this.currentElement.equals("HostAuthorizations")) {
                throw new SAXException("Unexpected parent element found!");
            }
            if (qname.equals("AllowHost")) {
                String hostname = attrs.getValue("HostName");
                String fingerprint = attrs.getValue("Fingerprint");
                if (hostname == null || fingerprint == null) throw new SAXException("Requried attribute(s) missing!");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("AllowHost element for host '" + hostname + "' with fingerprint '" + fingerprint + "'"));
                }
                this.allowedHosts.put(hostname, fingerprint);
                this.currentElement = qname;
                return;
            } else if (qname.equals("DenyHost")) {
                String hostname = attrs.getValue("HostName");
                if (hostname == null) throw new SAXException("Required attribute hostname missing");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("DenyHost element for host " + hostname));
                }
                this.deniedHosts.add(hostname);
                this.currentElement = qname;
                return;
            } else {
                log.warn((Object)("Unexpected " + qname + " element found in allowed hosts file"));
            }
        }
    }

    public void endElement(String uri, String localName, String qname) throws SAXException {
        if (this.currentElement == null) {
            throw new SAXException("Unexpected end element found!");
        }
        if (this.currentElement.equals("HostAuthorizations")) {
            this.currentElement = null;
            return;
        }
        if (this.currentElement.equals("AllowHost")) {
            this.currentElement = "HostAuthorizations";
            return;
        }
        if (this.currentElement.equals("DenyHost")) {
            this.currentElement = "HostAuthorizations";
            return;
        }
    }

    public boolean isHostFileWriteable() {
        return this.hostFileWriteable;
    }

    public abstract void onDeniedHost(String var1) throws TransportProtocolException;

    public abstract void onHostKeyMismatch(String var1, String var2, String var3) throws TransportProtocolException;

    public abstract void onUnknownHost(String var1, String var2) throws TransportProtocolException;

    public void allowHost(String host, String hostKeyFingerprint, boolean always) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Allowing " + host + " with fingerprint " + hostKeyFingerprint));
        }
        this.allowedHosts.put(host, hostKeyFingerprint);
        if (always) {
            this.saveHostFile();
        }
    }

    public Map allowedHosts() {
        return this.allowedHosts;
    }

    public List deniedHosts() {
        return this.deniedHosts;
    }

    public void removeAllowedHost(String host) {
        this.allowedHosts.remove(host);
    }

    public void removeDeniedHost(String host) {
        int i = this.deniedHosts.size() - 1;
        while (i >= 0) {
            String h = (String)this.deniedHosts.get(i);
            if (h.equals(host)) {
                this.deniedHosts.remove(i);
            }
            --i;
        }
    }

    public void denyHost(String host, boolean always) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)(String.valueOf(host) + " is denied access"));
        }
        if (!this.deniedHosts.contains(host)) {
            this.deniedHosts.add(host);
        }
        if (always) {
            this.saveHostFile();
        }
    }

    public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
        String fingerprint = pk.getFingerprint();
        log.info((Object)("Verifying " + host + " host key"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fingerprint: " + fingerprint));
        }
        if (this.deniedHosts.contains(host)) {
            this.onDeniedHost(host);
            return false;
        }
        if (this.allowedHosts.containsKey(host)) {
            String currentFingerprint = (String)this.allowedHosts.get(host);
            if (currentFingerprint.compareToIgnoreCase(fingerprint) == 0) {
                return true;
            }
            this.onHostKeyMismatch(host, currentFingerprint, fingerprint);
            return this.checkFingerprint(host, fingerprint);
        }
        this.onUnknownHost(host, fingerprint);
        return this.checkFingerprint(host, fingerprint);
    }

    private boolean checkFingerprint(String host, String fingerprint) {
        String currentFingerprint = (String)this.allowedHosts.get(host);
        return currentFingerprint != null && currentFingerprint.compareToIgnoreCase(fingerprint) == 0;
    }

    public void saveHostFile() throws InvalidHostFileException {
        if (!this.hostFileWriteable) {
            throw new InvalidHostFileException("Host file is not writeable.");
        }
        log.info((Object)("Saving " + defaultHostFile));
        try {
            File f = new File(this.hostFile);
            FileOutputStream out = new FileOutputStream(f);
            out.write(this.toString().getBytes());
            out.close();
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not write to " + this.hostFile);
        }
    }

    public String toString() {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<HostAuthorizations>\n";
        xml = String.valueOf(xml) + "<!-- Host Authorizations file, used by the abstract class HostKeyVerification to verify the servers host key -->";
        xml = String.valueOf(xml) + "   <!-- Allow the following hosts access if they provide the correct public key -->\n";
        for (Map.Entry entry : this.allowedHosts.entrySet()) {
            xml = String.valueOf(xml) + "   <AllowHost HostName=\"" + entry.getKey().toString() + "\" Fingerprint=\"" + entry.getValue().toString() + "\"/>\n";
        }
        xml = String.valueOf(xml) + "   <!-- Deny the following hosts access -->\n";
        Iterator it = this.deniedHosts.iterator();
        while (it.hasNext()) {
            xml = String.valueOf(xml) + "   <DenyHost HostName=\"" + it.next().toString() + "\"/>\n";
        }
        xml = String.valueOf(xml) + "</HostAuthorizations>";
        return xml;
    }
}

