/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.AboutAction;
import com.sshtools.common.ui.SshToolsApplication;
import com.sshtools.common.ui.SshToolsApplicationContainer;
import com.sshtools.common.ui.SshToolsApplicationException;
import com.sshtools.common.ui.SshToolsApplicationPanel;
import com.sshtools.common.ui.StandardAction;
import com.sshtools.common.ui.UIUtil;
import com.sshtools.common.util.PropertyUtil;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SshToolsApplicationApplet
extends JApplet {
    public static final String[][] PARAMETER_INFO = new String[][]{{"sshapps.log.file", "string", "Logging output destination. Defaults to @console@"}, {"sshapps.log.level", "string", "Logging level. DEBUG,FATAL,ERROR,WARN,INFO,DEBUG or OFF. Defaults to OFF"}, {"sshapps.ui.informationPanel.background", "hex color", "Set the background color of the 'information panel'"}, {"sshapps.ui.informationPanel.foreground", "boolean", "Set the foreground color of the 'information panel'"}, {"sshapps.ui.informationPanel.borderColor", "boolean", "Set the border color of the 'information panel'"}, {"sshapps.ui.informationPanel.borderThickness", "integer", "Set the border thickness of the 'information panel'"}, {"sshapps.ui.toolBar", "boolean", "Enable / Disable the tool bar"}, {"sshapps.ui.menuBar", "boolean", "Enable / Disable the menu bar"}, {"sshapps.ui.disabledActions", "string", "Comma (,) separated list of disable actions"}, {"sshapps.ui.statusBar", "boolean", "Enable / Disable the menu bar"}};
    protected Log log = LogFactory.getLog(SshToolsApplicationApplet.class);
    protected LoadingPanel loadingPanel;
    protected JSeparator toolSeparator;
    protected SshToolsApplicationPanel applicationPanel;
    protected Color infoForeground;
    protected int infoBorderThickness;
    protected boolean toolBar;
    protected boolean menuBar;
    protected boolean statusBar;
    protected Color infoBackground;
    protected Color infoBorderColor;
    protected String disabledActions;

    public String getParameter(String key, String def) {
        String v = this.getParameter(key);
        return v != null ? v : def;
    }

    public void init() {
        try {
            Runnable r = new Runnable(){

                public void run() {
                    try {
                        SshToolsApplicationApplet.this.getContentPane().setLayout(new BorderLayout());
                        SshToolsApplicationApplet.this.loadingPanel = new LoadingPanel();
                        SshToolsApplicationApplet.this.setAppletComponent(SshToolsApplicationApplet.this.loadingPanel);
                        SshToolsApplicationApplet.this.initApplet();
                        JComponent p = SshToolsApplicationApplet.this.buildAppletComponent();
                        SshToolsApplicationApplet.this.startApplet();
                        SshToolsApplicationApplet.this.setAppletComponent(p);
                    }
                    catch (Throwable t) {
                        SshToolsApplicationApplet.this.seriousAppletError(t);
                    }
                }
            };
            Thread t = new Thread(r);
            t.start();
        }
        catch (Throwable t) {
            this.seriousAppletError(t);
        }
    }

    public void initApplet() throws IOException {
        ConfigurationLoader.initialize(false);
        this.infoBackground = PropertyUtil.stringToColor(this.getParameter("sshapps.ui.informationPanel.background", PropertyUtil.colorToString(new Color(255, 255, 204))));
        this.infoForeground = PropertyUtil.stringToColor(this.getParameter("sshapps.ui.informationPanel.foreground", PropertyUtil.colorToString(Color.black)));
        this.infoBorderColor = PropertyUtil.stringToColor(this.getParameter("sshapps.ui.informationPanel.borderColor", PropertyUtil.colorToString(Color.black)));
        this.infoBorderThickness = PropertyUtil.stringToInt(this.getParameter("sshapps.ui.informationPanel.borderThickness", "1"), 1);
        this.toolBar = this.getParameter("sshapps.ui.toolBar", "true").equalsIgnoreCase("true");
        this.menuBar = this.getParameter("sshapps.ui.menuBar", "true").equalsIgnoreCase("true");
        this.statusBar = this.getParameter("sshapps.ui.statusBar", "true").equalsIgnoreCase("true");
        this.disabledActions = this.getParameter("sshapps.ui.disabledActions", "");
    }

    public void startApplet() {
    }

    public JComponent buildAppletComponent() throws IOException, SshToolsApplicationException {
        this.loadingPanel.setStatus("Creating application");
        this.applicationPanel = this.createApplicationPanel();
        this.loadingPanel.setStatus("Building action components");
        this.applicationPanel.rebuildActionComponents();
        this.log.debug((Object)("Disabled actions list = " + this.disabledActions));
        StringTokenizer tk = new StringTokenizer(this.disabledActions == null ? "" : this.disabledActions, ",");
        while (tk.hasMoreTokens()) {
            String n = tk.nextToken();
            this.log.debug((Object)("Disable " + n));
            this.applicationPanel.setActionVisible(n, false);
        }
        JPanel p = new JPanel(new BorderLayout());
        JPanel n = new JPanel(new BorderLayout());
        if (this.applicationPanel.getJMenuBar() != null) {
            n.add((Component)this.applicationPanel.getJMenuBar(), "North");
            this.log.debug((Object)("Setting menu bar visibility to " + this.menuBar));
            this.applicationPanel.setMenuBarVisible(this.menuBar);
        }
        if (this.applicationPanel.getToolBar() != null) {
            JPanel t = new JPanel(new BorderLayout());
            t.add((Component)this.applicationPanel.getToolBar(), "North");
            this.applicationPanel.setToolBarVisible(this.toolBar);
            this.toolSeparator = new JSeparator(0);
            t.add((Component)this.toolSeparator, "South");
            this.toolSeparator.setVisible(this.applicationPanel.getToolBar().isVisible());
            final SshToolsApplicationPanel pnl = this.applicationPanel;
            this.applicationPanel.getToolBar().addComponentListener(new ComponentAdapter(){

                public void componentHidden(ComponentEvent evt) {
                    SshToolsApplicationApplet.this.toolSeparator.setVisible(pnl.getToolBar().isVisible());
                }
            });
            n.add((Component)t, "South");
        }
        p.add((Component)n, "North");
        p.add((Component)this.applicationPanel, "Center");
        if (this.applicationPanel.getStatusBar() != null) {
            p.add((Component)this.applicationPanel.getStatusBar(), "South");
            this.applicationPanel.setStatusBarVisible(this.statusBar);
        }
        return p;
    }

    public void doAction(String name) {
        StandardAction a = this.applicationPanel.getAction(name);
        if (a != null) {
            if (a.isEnabled()) {
                this.log.debug((Object)("Performing action " + a.getName()));
                a.actionPerformed(new ActionEvent(this, 1001, a.getActionCommand()));
            } else {
                this.log.warn((Object)("No performing action '" + a.getName() + "' because it is disabled."));
            }
        } else {
            this.log.error((Object)("No action named " + name));
        }
    }

    public abstract SshToolsApplicationPanel createApplicationPanel() throws SshToolsApplicationException;

    protected void setAppletComponent(JComponent component) {
        if (this.getContentPane().getComponentCount() > 0) {
            this.getContentPane().invalidate();
            this.getContentPane().removeAll();
        }
        this.getContentPane().add((Component)component, "Center");
        this.getContentPane().validate();
        this.getContentPane().repaint();
    }

    protected void seriousAppletError(Throwable t) {
        StringBuffer buf = new StringBuffer();
        buf.append("<html><p>A serious error has occured ...</p><br>");
        buf.append("<p><font size=\"-1\" color=\"#ff0000\"><b>");
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter((Writer)writer, true));
        StringTokenizer tk = new StringTokenizer(writer.toString(), "\n");
        while (tk.hasMoreTokens()) {
            String msg = tk.nextToken();
            buf.append(msg);
            if (!tk.hasMoreTokens()) continue;
            buf.append("<br>");
        }
        buf.append("</b></font></p><html>");
        SshToolsApplicationAppletPanel p = new SshToolsApplicationAppletPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 10;
        gbc.insets = new Insets(0, 0, 8, 0);
        gbc.fill = 0;
        UIUtil.jGridBagAdd(p, new JLabel(buf.toString()), gbc, 0);
        this.setAppletComponent(p);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public String[][] getParameterInfo() {
        return PARAMETER_INFO;
    }

    class LoadingPanel
    extends SshToolsApplicationAppletPanel {
        private JProgressBar bar;

        LoadingPanel() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 10;
            gbc.insets = new Insets(0, 0, 8, 0);
            gbc.fill = 0;
            UIUtil.jGridBagAdd(this, new JLabel("Loading " + SshToolsApplicationApplet.this.getAppletInfo()), gbc, 0);
            this.bar = new JProgressBar(0, 100);
            this.bar.setStringPainted(true);
            UIUtil.jGridBagAdd(this, this.bar, gbc, 0);
        }

        public void setStatus(String status) {
            this.bar.setString(status);
        }
    }

    public class SshToolsApplicationAppletContainer
    extends JPanel
    implements SshToolsApplicationContainer {
        private SshToolsApplicationPanel panel;
        private SshToolsApplication application;

        public void init(SshToolsApplication application, SshToolsApplicationPanel panel) throws SshToolsApplicationException {
            this.application = application;
            this.panel = panel;
            panel.registerActionMenu(new SshToolsApplicationPanel.ActionMenu("Help", "Help", 104, 99));
            panel.registerAction(new AboutAction(this, application));
            this.getApplicationPanel().rebuildActionComponents();
        }

        public void setContainerTitle(String title) {
            SshToolsApplicationApplet.this.getAppletContext().showStatus(title);
        }

        public SshToolsApplicationPanel getApplicationPanel() {
            return this.panel;
        }

        public void closeContainer() {
        }

        public void setContainerVisible(boolean visible) {
            this.setVisible(visible);
        }

        public boolean isContainerVisible() {
            return this.isVisible();
        }
    }

    class SshToolsApplicationAppletPanel
    extends JPanel {
        SshToolsApplicationAppletPanel() {
            this.setOpaque(true);
            this.setBackground(SshToolsApplicationApplet.this.infoBackground);
            this.setForeground(SshToolsApplicationApplet.this.infoForeground);
            this.setBorder(BorderFactory.createLineBorder(SshToolsApplicationApplet.this.infoBorderColor, SshToolsApplicationApplet.this.infoBorderThickness));
        }
    }
}

