/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.util;

import java.awt.Color;
import java.awt.Font;
import java.util.StringTokenizer;

public class PropertyUtil {
    public static int stringToInt(String number, int defaultValue) {
        try {
            return number == null ? defaultValue : Integer.parseInt(number);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public static String colorToString(Color color) {
        StringBuffer buf = new StringBuffer();
        buf.append('#');
        buf.append(PropertyUtil.numberToPaddedHexString(color.getRed(), 2));
        buf.append(PropertyUtil.numberToPaddedHexString(color.getGreen(), 2));
        buf.append(PropertyUtil.numberToPaddedHexString(color.getBlue(), 2));
        return buf.toString();
    }

    public static String fontToString(Font font) {
        StringBuffer b = new StringBuffer(font.getName());
        b.append(",");
        b.append(font.getStyle());
        b.append(",");
        b.append(font.getSize());
        return b.toString();
    }

    public static Font stringToFont(String fontString) {
        StringTokenizer st = new StringTokenizer(fontString, ",");
        try {
            return new Font(st.nextToken(), Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Color stringToColor(String s) {
        try {
            return new Color(Integer.decode("0x" + s.substring(1, 3)), Integer.decode("0x" + s.substring(3, 5)), Integer.decode("0x" + s.substring(5, 7)));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Bad color string format. Should be #rrggbb ");
        }
    }

    public static String numberToPaddedHexString(int number, int size) {
        String s = Integer.toHexString(number);
        if (s.length() > size) {
            throw new IllegalArgumentException("Number too big for padded hex string");
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < size - s.length()) {
            buf.append('0');
            ++i;
        }
        buf.append(s);
        return buf.toString();
    }
}

