/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.authentication;

import com.sshtools.daemon.authentication.KBIPasswordAuthenticationServer;
import com.sshtools.daemon.authentication.PasswordAuthenticationServer;
import com.sshtools.daemon.authentication.PublicKeyAuthenticationServer;
import com.sshtools.daemon.authentication.SshAuthenticationServer;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationServerFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";

    static {
        log = LogFactory.getLog(SshAuthenticationServerFactory.class);
        auths = new HashMap();
        log.info((Object)"Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, PasswordAuthenticationServer.class);
        auths.put(AUTH_PK, PublicKeyAuthenticationServer.class);
        auths.put(AUTH_KBI, KBIPasswordAuthenticationServer.class);
        try {
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class)) {
                SshAPIConfiguration config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class);
                List addons = config.getAuthenticationExtensions();
                for (ExtensionAlgorithm method : addons) {
                    String name = method.getAlgorithmName();
                    if (auths.containsKey(name)) {
                        log.debug((Object)("Standard authentication implementation for " + name + " is being overidden by " + method.getImplementationClass()));
                    } else {
                        log.debug((Object)(String.valueOf(name) + " authentication is implemented by " + method.getImplementationClass()));
                    }
                    try {
                        Class cls = ConfigurationLoader.getExtensionClass(method.getImplementationClass());
                        Object obj = cls.newInstance();
                        if (!(obj instanceof SshAuthenticationServer)) continue;
                        auths.put(name, cls);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to load extension authentication implementation " + method.getImplementationClass()), (Throwable)e);
                    }
                }
            }
        }
        catch (ConfigurationException configurationException) {}
    }

    protected SshAuthenticationServerFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList list = new ArrayList(auths.keySet());
        return list;
    }

    public static SshAuthenticationServer newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshAuthenticationServer)((Class)auths.get(methodName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(String.valueOf(methodName) + " is not supported!");
        }
    }
}

