/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.daemon.forwarding;

import com.sshtools.j2ssh.connection.Channel;
import com.sshtools.j2ssh.connection.ChannelFactory;
import com.sshtools.j2ssh.connection.ConnectionProtocol;
import com.sshtools.j2ssh.connection.GlobalRequestHandler;
import com.sshtools.j2ssh.connection.GlobalRequestResponse;
import com.sshtools.j2ssh.connection.InvalidChannelException;
import com.sshtools.j2ssh.forwarding.ForwardingConfiguration;
import com.sshtools.j2ssh.forwarding.ForwardingConfigurationException;
import com.sshtools.j2ssh.forwarding.ForwardingListener;
import com.sshtools.j2ssh.forwarding.ForwardingSocketChannel;
import com.sshtools.j2ssh.io.ByteArrayReader;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketPermission;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingServer
implements ChannelFactory,
GlobalRequestHandler {
    private static Log log = LogFactory.getLog(ForwardingServer.class);
    private ConnectionProtocol connection;
    private List channelTypes = new Vector();
    private List localForwardings = new Vector();
    private List remoteForwardings = new Vector();

    public ForwardingServer(ConnectionProtocol connection) throws IOException {
        this.connection = connection;
        this.channelTypes.add("direct-tcpip");
        connection.addChannelFactory("direct-tcpip", this);
        connection.allowGlobalRequest("tcpip-forward", this);
        connection.allowGlobalRequest("cancel-tcpip-forward", this);
    }

    public Channel createChannel(String channelType, byte[] requestData) throws InvalidChannelException {
        if (!channelType.equals("direct-tcpip")) {
            throw new InvalidChannelException("The client can only request the opening of a local forwarding channel");
        }
        try {
            ByteArrayReader bar = new ByteArrayReader(requestData);
            String hostToConnect = bar.readString();
            int portToConnect = (int)bar.readInt();
            String originatingHost = bar.readString();
            int originatingPort = (int)bar.readInt();
            ForwardingConfiguration config = this.getLocalForwardingByAddress(originatingHost, originatingPort);
            Socket socket = new Socket(hostToConnect, portToConnect);
            ForwardingSocketChannel channel = config.createForwardingSocketChannel(channelType, hostToConnect, portToConnect, originatingHost, originatingPort);
            channel.bindSocket(socket);
            return channel;
        }
        catch (ForwardingConfigurationException forwardingConfigurationException) {
            throw new InvalidChannelException("No valid forwarding configuration was available for the request");
        }
        catch (IOException iOException) {
            throw new InvalidChannelException("The channel request data is invalid/or corrupt for channel type " + channelType);
        }
    }

    public GlobalRequestResponse processGlobalRequest(String requestName, byte[] requestData) {
        GlobalRequestResponse response = new GlobalRequestResponse(false);
        String addressToBind = null;
        int portToBind = -1;
        log.debug((Object)("Processing " + requestName + " global request"));
        try {
            ByteArrayReader bar = new ByteArrayReader(requestData);
            addressToBind = bar.readString();
            portToBind = (int)bar.readInt();
            if (requestName.equals("tcpip-forward")) {
                this.addRemoteForwardingConfiguration(addressToBind, portToBind);
                response = new GlobalRequestResponse(true);
            }
            if (requestName.equals("cancel-tcpip-forward")) {
                this.removeRemoteForwarding(addressToBind, portToBind);
                response = new GlobalRequestResponse(true);
            }
        }
        catch (IOException ioe) {
            log.warn((Object)("The client failed to request " + requestName + " for " + addressToBind + ":" + String.valueOf(portToBind)), (Throwable)ioe);
        }
        return response;
    }

    protected ForwardingConfiguration getLocalForwardingByAddress(String orginatingAddress, int originatingPort) throws ForwardingConfigurationException {
        try {
            ForwardingConfiguration config2;
            for (ForwardingConfiguration config2 : this.localForwardings) {
                if (!config2.getAddressToBind().equals(orginatingAddress) || config2.getPortToBind() != originatingPort) continue;
                return config2;
            }
            config2 = new ForwardingConfiguration(orginatingAddress, originatingPort);
            config2.start();
            this.localForwardings.add(config2);
            return config2;
        }
        catch (IOException ex) {
            throw new ForwardingConfigurationException(ex.getMessage());
        }
    }

    protected ForwardingConfiguration getRemoteForwardingByAddress(String addressToBind, int portToBind) throws ForwardingConfigurationException {
        for (ForwardingConfiguration config : this.remoteForwardings) {
            if (!config.getAddressToBind().equals(addressToBind) || config.getPortToBind() != portToBind) continue;
            return config;
        }
        throw new ForwardingConfigurationException("The remote forwarding does not exist!");
    }

    protected void addRemoteForwardingConfiguration(String addressToBind, int portToBind) throws ForwardingConfigurationException {
        ForwardingConfiguration config2;
        for (ForwardingConfiguration config2 : this.remoteForwardings) {
            if (!config2.getAddressToBind().equals(addressToBind) || config2.getPortToBind() != portToBind) continue;
            throw new ForwardingConfigurationException("The address and port are already in use!");
        }
        config2 = new ForwardingConfiguration(addressToBind, portToBind);
        SecurityManager manager = System.getSecurityManager();
        if (manager != null) {
            try {
                manager.checkPermission(new SocketPermission(String.valueOf(addressToBind) + ":" + String.valueOf(portToBind), "accept,listen"));
            }
            catch (SecurityException securityException) {
                throw new ForwardingConfigurationException("The security manager has denied listen permision on " + addressToBind + ":" + String.valueOf(portToBind));
            }
        }
        try {
            ServerForwardingListener listener = new ServerForwardingListener(this.connection, addressToBind, portToBind);
            this.remoteForwardings.add(listener);
            listener.start();
        }
        catch (IOException ex) {
            throw new ForwardingConfigurationException(ex.getMessage());
        }
    }

    protected void removeRemoteForwarding(String addressToBind, int portToBind) throws ForwardingConfigurationException {
        ForwardingConfiguration config = this.getRemoteForwardingByAddress(addressToBind, portToBind);
        config.stop();
        this.remoteForwardings.remove(config);
    }

    class ServerForwardingListener
    extends ForwardingListener {
        public ServerForwardingListener(ConnectionProtocol connection, String addressToBind, int portToBind) {
            super(connection, addressToBind, portToBind);
        }

        public ForwardingSocketChannel createChannel(String hostToConnect, int portToConnect, Socket socket) throws ForwardingConfigurationException {
            try {
                ForwardingSocketChannel channel = this.createForwardingSocketChannel("forwarded-tcpip", hostToConnect, portToConnect, socket.getInetAddress().getHostAddress(), socket.getPort());
                channel.bindSocket(socket);
                return channel;
            }
            catch (IOException ex) {
                throw new ForwardingConfigurationException(ex.getMessage());
            }
        }
    }
}

