/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.authentication;

import com.sshtools.j2ssh.authentication.KBIAuthenticationClient;
import com.sshtools.j2ssh.authentication.PasswordAuthenticationClient;
import com.sshtools.j2ssh.authentication.PublicKeyAuthenticationClient;
import com.sshtools.j2ssh.authentication.SshAuthenticationClient;
import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import java.io.FilePermission;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshAuthenticationClientFactory {
    private static Map auths;
    private static Log log;
    public static final String AUTH_PASSWORD = "password";
    public static final String AUTH_PK = "publickey";
    public static final String AUTH_KBI = "keyboard-interactive";
    public static final String AUTH_HOSTBASED = "hostbased";

    static {
        log = LogFactory.getLog(SshAuthenticationClientFactory.class);
        auths = new HashMap();
        log.info((Object)"Loading supported authentication methods");
        auths.put(AUTH_PASSWORD, PasswordAuthenticationClient.class);
        try {
            if (System.getSecurityManager() != null) {
                AccessController.checkPermission(new FilePermission("<<ALL FILES>>", "read"));
            }
            auths.put(AUTH_PK, PublicKeyAuthenticationClient.class);
        }
        catch (AccessControlException accessControlException) {
            log.info((Object)"The security manager prevents use of Public Key Authentication on the client");
        }
        auths.put(AUTH_KBI, KBIAuthenticationClient.class);
        try {
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class)) {
                SshAPIConfiguration config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class);
                List addons = config.getAuthenticationExtensions();
                for (ExtensionAlgorithm method : addons) {
                    String name = method.getAlgorithmName();
                    if (auths.containsKey(name)) {
                        log.debug((Object)("Standard authentication implementation for " + name + " is being overidden by " + method.getImplementationClass()));
                    } else {
                        log.debug((Object)(String.valueOf(name) + " authentication is implemented by " + method.getImplementationClass()));
                    }
                    try {
                        Class cls = ConfigurationLoader.getExtensionClass(method.getImplementationClass());
                        Object obj = cls.newInstance();
                        if (!(obj instanceof SshAuthenticationClient)) continue;
                        auths.put(name, cls);
                    }
                    catch (Exception e) {
                        log.warn((Object)("Failed to load extension authentication implementation" + method.getImplementationClass()), (Throwable)e);
                    }
                }
            }
        }
        catch (ConfigurationException configurationException) {}
    }

    protected SshAuthenticationClientFactory() {
    }

    public static void initialize() {
    }

    public static List getSupportedMethods() {
        ArrayList list = new ArrayList(auths.keySet());
        return list;
    }

    public static SshAuthenticationClient newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshAuthenticationClient)((Class)auths.get(methodName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(String.valueOf(methodName) + " is not supported!");
        }
    }
}

