/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.connection;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import com.sshtools.j2ssh.transport.SshMessage;
import java.io.IOException;

public class SshMsgChannelOpenConfirmation
extends SshMessage {
    protected static final int SSH_MSG_CHANNEL_OPEN_CONFIRMATION = 91;
    private byte[] channelData;
    private long initialWindowSize;
    private long maximumPacketSize;
    private long recipientChannel;
    private long senderChannel;

    public SshMsgChannelOpenConfirmation(long recipientChannel, long senderChannel, long initialWindowSize, long maximumPacketSize, byte[] channelData) {
        super(91);
        this.recipientChannel = recipientChannel;
        this.senderChannel = senderChannel;
        this.initialWindowSize = initialWindowSize;
        this.maximumPacketSize = maximumPacketSize;
        this.channelData = channelData;
    }

    public SshMsgChannelOpenConfirmation() {
        super(91);
    }

    public byte[] getChannelData() {
        return this.channelData;
    }

    public long getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public String getMessageName() {
        return "SSH_MSG_CHANNEL_OPEN_CONFIRMATION";
    }

    public long getRecipientChannel() {
        return this.recipientChannel;
    }

    public long getSenderChannel() {
        return this.senderChannel;
    }

    protected void constructByteArray(ByteArrayWriter baw) throws InvalidMessageException {
        try {
            baw.writeInt(this.recipientChannel);
            baw.writeInt(this.senderChannel);
            baw.writeInt(this.initialWindowSize);
            baw.writeInt(this.maximumPacketSize);
            if (this.channelData != null) {
                baw.write(this.channelData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }

    protected void constructMessage(ByteArrayReader bar) throws InvalidMessageException {
        try {
            this.recipientChannel = bar.readInt();
            this.senderChannel = bar.readInt();
            this.initialWindowSize = bar.readInt();
            this.maximumPacketSize = bar.readInt();
            if (bar.available() > 0) {
                this.channelData = new byte[bar.available()];
                bar.read(this.channelData);
            }
        }
        catch (IOException iOException) {
            throw new InvalidMessageException("Invalid message data");
        }
    }
}

