/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DynamicBuffer {
    private static Log log = LogFactory.getLog(DynamicBuffer.class);
    protected static final int DEFAULT_BUFFER_SIZE = 32768;
    protected byte[] buf = new byte[32768];
    protected int writepos = 0;
    protected int readpos = 0;
    protected InputStream in = new DynamicBufferInputStream();
    protected OutputStream out = new DynamicBufferOutputStream();
    private boolean closed = false;
    private int interrupt = 5000;

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    private synchronized void verifyBufferSize(int count) {
        if (count > this.buf.length - this.writepos) {
            System.arraycopy(this.buf, this.readpos, this.buf, 0, this.writepos - this.readpos);
            this.writepos -= this.readpos;
            this.readpos = 0;
        }
        if (count > this.buf.length - this.writepos) {
            byte[] tmp = new byte[this.buf.length + 32768];
            System.arraycopy(this.buf, 0, tmp, 0, this.writepos - this.readpos);
            this.buf = tmp;
        }
    }

    protected synchronized int available() {
        return this.writepos - this.readpos;
    }

    private synchronized void block() throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Buffer size: " + String.valueOf(this.buf.length)));
            log.debug((Object)("Unread data: " + String.valueOf(this.writepos - this.readpos)));
        }
        if (!this.closed) {
            while (this.readpos >= this.writepos && !this.closed) {
                this.wait(this.interrupt);
            }
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.notifyAll();
        }
    }

    protected synchronized void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException("The buffer is closed");
        }
        this.verifyBufferSize(1);
        this.buf[this.writepos] = (byte)b;
        ++this.writepos;
        this.notifyAll();
    }

    protected synchronized void write(byte[] data, int offset, int len) throws IOException {
        if (this.closed) {
            throw new IOException("The buffer is closed");
        }
        this.verifyBufferSize(len);
        System.arraycopy(data, offset, this.buf, this.writepos, len);
        this.writepos += len;
        this.notifyAll();
    }

    public void setBlockInterrupt(int interrupt) {
        this.interrupt = interrupt;
    }

    protected synchronized int read() throws IOException {
        try {
            this.block();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("The blocking operation was interrupted");
        }
        if (this.closed && this.available() <= 0) {
            return -1;
        }
        return this.buf[this.readpos++];
    }

    protected synchronized int read(byte[] data, int offset, int len) throws IOException {
        try {
            this.block();
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException("The blocking operation was interrupted");
        }
        if (this.closed && this.available() <= 0) {
            return -1;
        }
        int read = len > this.writepos - this.readpos ? this.writepos - this.readpos : len;
        System.arraycopy(this.buf, this.readpos, data, offset, read);
        this.readpos += read;
        return read;
    }

    protected synchronized void flush() throws IOException {
        this.notifyAll();
    }

    class DynamicBufferInputStream
    extends InputStream {
        DynamicBufferInputStream() {
        }

        public int read() throws IOException {
            return DynamicBuffer.this.read();
        }

        public int read(byte[] data, int offset, int len) throws IOException {
            return DynamicBuffer.this.read(data, offset, len);
        }

        public int available() {
            return DynamicBuffer.this.available();
        }

        public void close() {
            DynamicBuffer.this.close();
        }
    }

    class DynamicBufferOutputStream
    extends OutputStream {
        DynamicBufferOutputStream() {
        }

        public void write(int b) throws IOException {
            DynamicBuffer.this.write(b);
        }

        public void write(byte[] data, int offset, int len) throws IOException {
            DynamicBuffer.this.write(data, offset, len);
        }

        public void flush() throws IOException {
            DynamicBuffer.this.flush();
        }

        public void close() {
            DynamicBuffer.this.close();
        }
    }
}

