/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.openssh;

import com.sshtools.j2ssh.openssh.KeyInfo;
import com.sshtools.j2ssh.util.SimpleASNReader;
import com.sshtools.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;

public class DSAKeyInfo
implements KeyInfo {
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;
    private BigInteger x;
    private BigInteger y;

    public DSAKeyInfo(BigInteger p, BigInteger q, BigInteger g, BigInteger x, BigInteger y) {
        this.p = p;
        this.q = q;
        this.g = g;
        this.x = x;
        this.y = y;
    }

    public BigInteger getG() {
        return this.g;
    }

    public BigInteger getP() {
        return this.p;
    }

    public BigInteger getQ() {
        return this.q;
    }

    public BigInteger getX() {
        return this.x;
    }

    public BigInteger getY() {
        return this.y;
    }

    public KeySpec getPrivateKeySpec() {
        return new DSAPrivateKeySpec(this.x, this.p, this.q, this.g);
    }

    public KeySpec getPublicKeySpec() {
        return new DSAPublicKeySpec(this.y, this.p, this.q, this.g);
    }

    public static DSAKeyInfo getDSAKeyInfo(SimpleASNReader asn) throws IOException {
        asn.assertByte(48);
        asn.getLength();
        asn.assertByte(2);
        asn.getData();
        asn.assertByte(2);
        byte[] paramP = asn.getData();
        asn.assertByte(2);
        byte[] paramQ = asn.getData();
        asn.assertByte(2);
        byte[] paramG = asn.getData();
        asn.assertByte(2);
        byte[] paramY = asn.getData();
        asn.assertByte(2);
        byte[] paramX = asn.getData();
        return new DSAKeyInfo(new BigInteger(paramP), new BigInteger(paramQ), new BigInteger(paramG), new BigInteger(paramX), new BigInteger(paramY));
    }

    public static void writeDSAKeyInfo(SimpleASNWriter asn, DSAKeyInfo keyInfo) {
        SimpleASNWriter asn2 = new SimpleASNWriter();
        asn2.writeByte(2);
        byte[] version = new byte[1];
        asn2.writeData(version);
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getP().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getQ().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getG().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getY().toByteArray());
        asn2.writeByte(2);
        asn2.writeData(keyInfo.getX().toByteArray());
        byte[] dsaKeyEncoded = asn2.toByteArray();
        asn.writeByte(48);
        asn.writeData(dsaKeyEncoded);
    }
}

