/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FileAttributes {
    public static final int SSH_FILEXFER_TYPE_REGULAR = 1;
    public static final int SSH_FILEXFER_TYPE_DIRECTORY = 2;
    public static final int SSH_FILEXFER_TYPE_SYMLINK = 3;
    public static final int SSH_FILEXFER_TYPE_SPECIAL = 4;
    public static final int SSH_FILEXFER_TYPE_UNKNOWN = 5;
    public static final int SSH_FILEXFER_TYPE_SOCKET = 6;
    public static final int SSH_FILEXFER_TYPE_CHAR_DEVICE = 7;
    public static final int SSH_FILEXFER_TYPE_BLOCK_DEVICE = 8;
    public static final int SSH_FILEXFER_TYPE_FIFO = 9;
    private static final int SSH_FILEXFER_ATTR_SIZE = 1;
    private static final int SSH_FILEXFER_ATTR_UIDGID = 2;
    private static final int SSH_FILEXFER_ATTR_PERMISSIONS = 4;
    private static final int SSH_FILEXFER_ATTR_ACCESSTIME = 8;
    private static final int SSH_FILEXFER_ATTR_CREATETIME = 16;
    private static final int SSH_FILEXFER_ATTR_MODIFYTIME = 32;
    private static final int SSH_FILEXFER_ATTR_ACL = 64;
    private static final int SSH_FILEXFER_ATTR_OWNERGROUP = 128;
    private static final int SSH_FILEXFER_ATTR_EXTENDED = 0x8000000;
    public static final int S_IFMT = 61440;
    public static final int S_IFSOCK = 49152;
    public static final int S_IFLNK = 40960;
    public static final int S_IFREG = 32768;
    public static final int S_IFBLK = 24576;
    public static final int S_IFDIR = 16384;
    public static final int S_IFCHR = 8192;
    public static final int S_IFIFO = 4096;
    public static final int S_ISUID = 2048;
    public static final int S_ISGID = 1024;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    int version = 3;
    long flags = 0L;
    int type;
    UnsignedInteger64 size = null;
    UnsignedInteger32 uid = null;
    UnsignedInteger32 gid = null;
    String owner = null;
    String group = null;
    UnsignedInteger32 permissions = null;
    UnsignedInteger32 atime = null;
    UnsignedInteger32 createtime = null;
    UnsignedInteger32 mtime = null;
    List acl = new Vector();
    Map extended = new HashMap();
    char[] types = new char[]{'p', 'c', 'd', 'b', '-', 'l', 's'};

    public FileAttributes() {
    }

    public FileAttributes(ByteArrayReader bar) throws IOException {
        this.flags = bar.readInt();
        if (this.isFlagSet(1)) {
            this.size = bar.readUINT64();
        }
        if (this.isFlagSet(2)) {
            this.uid = bar.readUINT32();
            this.gid = bar.readUINT32();
        }
        if (this.isFlagSet(4)) {
            this.permissions = bar.readUINT32();
        }
        if (this.isFlagSet(8)) {
            this.atime = bar.readUINT32();
            this.mtime = bar.readUINT32();
        }
        if (this.isFlagSet(0x8000000)) {
            int count = (int)bar.readInt();
            int i = 0;
            while (i < count) {
                String type = bar.readString();
                String data = bar.readString();
                this.extended.put(type, data);
                ++i;
            }
        }
    }

    public UnsignedInteger32 getUID() {
        if (this.uid != null) {
            return this.uid;
        }
        return new UnsignedInteger32(0L);
    }

    public void setUID(UnsignedInteger32 uid) {
        this.flags |= 2L;
        this.uid = uid;
    }

    public void setGID(UnsignedInteger32 gid) {
        this.flags |= 2L;
        this.gid = gid;
    }

    public UnsignedInteger32 getGID() {
        if (this.gid != null) {
            return this.gid;
        }
        return new UnsignedInteger32(0L);
    }

    public void setSize(UnsignedInteger64 size) {
        this.size = size;
        this.flags = size != null ? (this.flags |= 1L) : (this.flags ^= 1L);
    }

    public UnsignedInteger64 getSize() {
        if (this.size != null) {
            return this.size;
        }
        return new UnsignedInteger64("0");
    }

    public void setPermissions(UnsignedInteger32 permissions) {
        this.permissions = permissions;
        this.flags = permissions != null ? (this.flags |= 4L) : (this.flags ^= 4L);
    }

    public void setPermissionsFromMaskString(String mask) {
        if (mask.length() != 4) {
            throw new IllegalArgumentException("Mask length must be 4");
        }
        try {
            this.setPermissions(new UnsignedInteger32(String.valueOf(Integer.parseInt(mask, 8))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Mask must be 4 digit octal number.");
        }
    }

    public void setPermissions(String newPermissions) {
        int len;
        int cp = 0;
        if (this.permissions != null) {
            cp |= (this.permissions.intValue() & 0xF000) == 61440 ? 61440 : 0;
            cp |= (this.permissions.intValue() & 0xC000) == 49152 ? 49152 : 0;
            cp |= (this.permissions.intValue() & 0xA000) == 40960 ? 40960 : 0;
            cp |= (this.permissions.intValue() & 0x8000) == 32768 ? 32768 : 0;
            cp |= (this.permissions.intValue() & 0x6000) == 24576 ? 24576 : 0;
            cp |= (this.permissions.intValue() & 0x4000) == 16384 ? 16384 : 0;
            cp |= (this.permissions.intValue() & 0x2000) == 8192 ? 8192 : 0;
            cp |= (this.permissions.intValue() & 0x1000) == 4096 ? 4096 : 0;
            cp |= (this.permissions.intValue() & 0x800) == 2048 ? 2048 : 0;
            cp |= (this.permissions.intValue() & 0x400) == 1024 ? 1024 : 0;
        }
        if ((len = newPermissions.length()) >= 1) {
            cp |= newPermissions.charAt(0) == 'r' ? 256 : 0;
        }
        if (len >= 2) {
            cp |= newPermissions.charAt(1) == 'w' ? 128 : 0;
        }
        if (len >= 3) {
            cp |= newPermissions.charAt(2) == 'x' ? 64 : 0;
        }
        if (len >= 4) {
            cp |= newPermissions.charAt(3) == 'r' ? 32 : 0;
        }
        if (len >= 5) {
            cp |= newPermissions.charAt(4) == 'w' ? 16 : 0;
        }
        if (len >= 6) {
            cp |= newPermissions.charAt(5) == 'x' ? 8 : 0;
        }
        if (len >= 7) {
            cp |= newPermissions.charAt(6) == 'r' ? 4 : 0;
        }
        if (len >= 8) {
            cp |= newPermissions.charAt(7) == 'w' ? 2 : 0;
        }
        if (len >= 9) {
            cp |= newPermissions.charAt(8) == 'x' ? 1 : 0;
        }
        this.setPermissions(new UnsignedInteger32(cp));
    }

    public UnsignedInteger32 getPermissions() {
        return this.permissions;
    }

    public void setTimes(UnsignedInteger32 atime, UnsignedInteger32 mtime) {
        this.atime = atime;
        this.mtime = mtime;
        this.flags = atime != null ? (this.flags |= 8L) : (this.flags ^= 8L);
    }

    public UnsignedInteger32 getAccessedTime() {
        return this.atime;
    }

    public UnsignedInteger32 getModifiedTime() {
        if (this.mtime != null) {
            return this.mtime;
        }
        return new UnsignedInteger32(0L);
    }

    public Map getExtendedAttributes() {
        return this.extended;
    }

    public boolean isFlagSet(int flag) {
        return (this.flags & (long)flag) == (long)flag;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayWriter baw = new ByteArrayWriter();
        if (this.extended.size() > 0) {
            this.flags |= 0x8000000L;
        }
        baw.writeInt(this.flags);
        if (this.isFlagSet(1)) {
            baw.writeUINT64(this.size);
        }
        if (this.isFlagSet(2)) {
            if (this.uid != null) {
                baw.writeUINT32(this.uid);
            } else {
                baw.writeInt(0);
            }
            if (this.gid != null) {
                baw.writeUINT32(this.gid);
            } else {
                baw.writeInt(0);
            }
        }
        if (this.isFlagSet(4)) {
            baw.writeUINT32(this.permissions);
        }
        if (this.isFlagSet(8)) {
            baw.writeUINT32(this.atime);
            baw.writeUINT32(this.mtime);
        }
        if (this.isFlagSet(0x8000000)) {
            baw.writeInt(this.extended.size());
            for (Map.Entry entry : this.extended.entrySet()) {
                baw.writeString((String)entry.getKey());
                baw.writeString((String)entry.getValue());
            }
        }
        return baw.toByteArray();
    }

    private int octal(int v, int r) {
        return (((v >>>= r) & 4) != 0 ? 4 : 0) + ((v & 2) != 0 ? 2 : 0) + ((v & 1) != 0 ? 1 : 0);
    }

    private String rwxString(int v, int r) {
        String rwx = String.valueOf(((v >>>= r) & 4) != 0 ? "r" : "-") + ((v & 2) != 0 ? "w" : "-");
        rwx = r == 6 && (this.permissions.intValue() & 0x800) == 2048 || r == 3 && (this.permissions.intValue() & 0x400) == 1024 ? String.valueOf(rwx) + ((v & 1) != 0 ? "s" : "S") : String.valueOf(rwx) + ((v & 1) != 0 ? "x" : "-");
        return rwx;
    }

    public String getPermissionsString() {
        if (this.permissions != null) {
            StringBuffer str = new StringBuffer();
            str.append(this.types[(this.permissions.intValue() & 0xF000) >>> 13]);
            str.append(this.rwxString(this.permissions.intValue(), 6));
            str.append(this.rwxString(this.permissions.intValue(), 3));
            str.append(this.rwxString(this.permissions.intValue(), 0));
            return str.toString();
        }
        return "";
    }

    public String getMaskString() {
        StringBuffer buf = new StringBuffer();
        buf.append('0');
        int i = this.permissions.intValue();
        buf.append(this.octal(i, 6));
        buf.append(this.octal(i, 3));
        buf.append(this.octal(i, 0));
        return buf.toString();
    }

    public String getModTimeString() {
        if (this.mtime == null) {
            return "";
        }
        long mt = this.mtime.longValue() * 1000L;
        long now = System.currentTimeMillis();
        SimpleDateFormat df = now - mt > 15552000000L ? new SimpleDateFormat("MMM dd  yyyy") : new SimpleDateFormat("MMM dd hh:mm");
        return df.format(new Date(mt));
    }

    public boolean isDirectory() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 16384;
    }

    public boolean isFile() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 32768;
    }

    public boolean isLink() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 40960;
    }

    public boolean isFifo() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 4096;
    }

    public boolean isBlock() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 24576;
    }

    public boolean isCharacter() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 8192;
    }

    public boolean isSocket() {
        if (this.permissions == null) {
            return false;
        }
        return (this.permissions.intValue() & 0xF000) == 49152;
    }
}

