/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.io.UnsignedInteger64;
import com.sshtools.j2ssh.sftp.MessageRequestId;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public class SshFxpRead
extends SubsystemMessage
implements MessageRequestId {
    public static final int SSH_FXP_READ = 5;
    private UnsignedInteger32 id;
    private byte[] handle;
    private UnsignedInteger64 offset;
    private UnsignedInteger32 length;

    public SshFxpRead(UnsignedInteger32 id, byte[] handle, UnsignedInteger64 offset, UnsignedInteger32 length) {
        super(5);
        this.id = id;
        this.handle = handle;
        this.offset = offset;
        this.length = length;
    }

    public SshFxpRead() {
        super(5);
    }

    public UnsignedInteger32 getId() {
        return this.id;
    }

    public byte[] getHandle() {
        return this.handle;
    }

    public UnsignedInteger64 getOffset() {
        return this.offset;
    }

    public UnsignedInteger32 getLength() {
        return this.length;
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        this.id = bar.readUINT32();
        this.handle = bar.readBinaryString();
        this.offset = bar.readUINT64();
        this.length = bar.readUINT32();
    }

    public String getMessageName() {
        return "SSH_FXP_READ";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        baw.writeUINT32(this.id);
        baw.writeBinaryString(this.handle);
        baw.writeUINT64(this.offset);
        baw.writeUINT32(this.length);
    }
}

