/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport;

import com.sshtools.j2ssh.transport.HostKeyVerification;
import com.sshtools.j2ssh.transport.InvalidHostFileException;
import com.sshtools.j2ssh.transport.TransportProtocolException;
import com.sshtools.j2ssh.transport.publickey.SshKeyPairFactory;
import com.sshtools.j2ssh.transport.publickey.SshPublicKey;
import com.sshtools.j2ssh.util.Base64;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractKnownHostsKeyVerification
implements HostKeyVerification {
    private static String defaultHostFile;
    private static Log log;
    private Map allowedHosts = new HashMap();
    private String knownhosts;
    private boolean hostFileWriteable;

    static {
        log = LogFactory.getLog(HostKeyVerification.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractKnownHostsKeyVerification(String knownhosts) throws InvalidHostFileException {
        InputStream in = null;
        try {
            if (knownhosts != null) {
                File f;
                if (System.getSecurityManager() != null) {
                    AccessController.checkPermission(new FilePermission(knownhosts, "read"));
                }
                if ((f = new File(knownhosts)).exists()) {
                    String line;
                    in = new FileInputStream(f);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    while ((line = reader.readLine()) != null) {
                        StringTokenizer tokens = new StringTokenizer(line, " ");
                        String host = (String)tokens.nextElement();
                        String cfr_ignored_0 = (String)tokens.nextElement();
                        String key = (String)tokens.nextElement();
                        SshPublicKey pk = SshKeyPairFactory.decodePublicKey(Base64.decode(key));
                        this.putAllowedKey(host, pk);
                    }
                    reader.close();
                    this.hostFileWriteable = f.canWrite();
                } else {
                    f.getParentFile().mkdirs();
                    if (f.createNewFile()) {
                        FileOutputStream out = new FileOutputStream(f);
                        out.write(this.toString().getBytes());
                        out.close();
                        this.hostFileWriteable = true;
                    } else {
                        this.hostFileWriteable = false;
                    }
                }
                if (!this.hostFileWriteable) {
                    log.warn((Object)"Host file is not writeable.");
                }
                this.knownhosts = knownhosts;
            }
        }
        catch (AccessControlException accessControlException) {
            this.hostFileWriteable = false;
            log.warn((Object)"Not enough permission to load a hosts file, so just creating an empty list");
            if (in == null) return;
            try {
                in.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException ioe) {
            try {
                this.hostFileWriteable = false;
                log.info((Object)("Could not open or read " + knownhosts + ": " + ioe.getMessage()));
                if (in == null) return;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (in == null) return;
        try {
            in.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public boolean isHostFileWriteable() {
        return this.hostFileWriteable;
    }

    public abstract void onHostKeyMismatch(String var1, SshPublicKey var2, SshPublicKey var3) throws TransportProtocolException;

    public abstract void onUnknownHost(String var1, SshPublicKey var2) throws TransportProtocolException;

    public void allowHost(String host, SshPublicKey pk, boolean always) throws InvalidHostFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Allowing " + host + " with fingerprint " + pk.getFingerprint()));
        }
        this.putAllowedKey(host, pk);
        if (always) {
            this.saveHostFile();
        }
    }

    public Map allowedHosts() {
        return this.allowedHosts;
    }

    public void removeAllowedHost(String host) {
        Iterator it = this.allowedHosts.keySet().iterator();
        while (it.hasNext()) {
            StringTokenizer tokens = new StringTokenizer((String)it.next(), ",");
            while (tokens.hasMoreElements()) {
                String name = (String)tokens.nextElement();
                if (!name.equals(host)) continue;
                this.allowedHosts.remove(name);
            }
        }
    }

    public boolean verifyHost(String host, SshPublicKey pk) throws TransportProtocolException {
        String fingerprint = pk.getFingerprint();
        log.info((Object)("Verifying " + host + " host key"));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fingerprint: " + fingerprint));
        }
        for (String names : this.allowedHosts.keySet()) {
            if (names.equals(host)) {
                return this.validateHost(names, pk);
            }
            StringTokenizer tokens = new StringTokenizer(names, ",");
            while (tokens.hasMoreElements()) {
                String name = (String)tokens.nextElement();
                if (!name.equalsIgnoreCase(host)) continue;
                return this.validateHost(names, pk);
            }
        }
        this.onUnknownHost(host, pk);
        return this.checkKey(host, pk);
    }

    private boolean validateHost(String names, SshPublicKey pk) throws TransportProtocolException {
        SshPublicKey pub = this.getAllowedKey(names, pk.getAlgorithmName());
        if (pub != null && pk.equals(pub)) {
            return true;
        }
        if (pub == null) {
            this.onUnknownHost(names, pk);
        } else {
            this.onHostKeyMismatch(names, pub, pk);
        }
        return this.checkKey(names, pk);
    }

    private boolean checkKey(String host, SshPublicKey key) {
        SshPublicKey pk = this.getAllowedKey(host, key.getAlgorithmName());
        return pk != null && pk.equals(key);
    }

    private SshPublicKey getAllowedKey(String names, String algorithm) {
        if (this.allowedHosts.containsKey(names)) {
            Map map = (Map)this.allowedHosts.get(names);
            return (SshPublicKey)map.get(algorithm);
        }
        return null;
    }

    private void putAllowedKey(String host, SshPublicKey key) {
        if (!this.allowedHosts.containsKey(host)) {
            this.allowedHosts.put(host, new HashMap());
        }
        Map map = (Map)this.allowedHosts.get(host);
        map.put(key.getAlgorithmName(), key);
    }

    public void saveHostFile() throws InvalidHostFileException {
        if (!this.hostFileWriteable) {
            throw new InvalidHostFileException("Host file is not writeable.");
        }
        log.info((Object)("Saving " + defaultHostFile));
        try {
            File f = new File(this.knownhosts);
            FileOutputStream out = new FileOutputStream(f);
            out.write(this.toString().getBytes());
            out.close();
        }
        catch (IOException iOException) {
            throw new InvalidHostFileException("Could not write to " + this.knownhosts);
        }
    }

    public String toString() {
        String knownhosts = "";
        for (Map.Entry entry : this.allowedHosts.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                SshPublicKey pk = (SshPublicKey)entry2.getValue();
                knownhosts = String.valueOf(knownhosts) + entry.getKey().toString() + " " + pk.getAlgorithmName() + " " + Base64.encodeBytes(pk.getEncoded(), true) + "\n";
            }
        }
        return knownhosts;
    }
}

