/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.hmac;

import com.sshtools.j2ssh.transport.AlgorithmInitializationException;
import com.sshtools.j2ssh.transport.hmac.SshHmac;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacMd5
implements SshHmac {
    private Mac mac;

    public int getMacLength() {
        return this.mac.getMacLength();
    }

    public byte[] generate(long sequenceNo, byte[] data, int offset, int len) {
        byte[] sequenceBytes = new byte[]{(byte)(sequenceNo >> 24), (byte)(sequenceNo >> 16), (byte)(sequenceNo >> 8), (byte)(sequenceNo >> 0)};
        this.mac.update(sequenceBytes);
        this.mac.update(data, offset, len);
        return this.mac.doFinal();
    }

    public void init(byte[] keydata) throws AlgorithmInitializationException {
        try {
            this.mac = Mac.getInstance("HmacMD5");
            byte[] key = new byte[16];
            System.arraycopy(keydata, 0, key, 0, key.length);
            SecretKeySpec keyspec = new SecretKeySpec(key, "HmacMD5");
            this.mac.init(keyspec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AlgorithmInitializationException("No provider exists for the HmacSha1 algorithm");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AlgorithmInitializationException("Invalid key");
        }
    }

    public boolean verify(long sequenceNo, byte[] data) {
        int len = this.getMacLength();
        byte[] generated = this.generate(sequenceNo, data, 0, data.length - len);
        String compare1 = new String(generated);
        String compare2 = new String(data, data.length - len, len);
        return compare1.equals(compare2);
    }
}

