/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.configuration.ConfigurationException;
import com.sshtools.j2ssh.configuration.ConfigurationLoader;
import com.sshtools.j2ssh.configuration.ExtensionAlgorithm;
import com.sshtools.j2ssh.configuration.SshAPIConfiguration;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.kex.DhGroup1Sha1;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshKeyExchangeFactory {
    private static Map kexs;
    private static String defaultAlgorithm;
    private static Log log;

    static {
        log = LogFactory.getLog(SshKeyExchangeFactory.class);
        kexs = new HashMap();
        log.info((Object)"Loading key exchange methods");
        kexs.put("diffie-hellman-group1-sha1", DhGroup1Sha1.class);
        try {
            SshAPIConfiguration config;
            if (ConfigurationLoader.isConfigurationAvailable(SshAPIConfiguration.class) && (config = (SshAPIConfiguration)ConfigurationLoader.getConfiguration(SshAPIConfiguration.class)) != null) {
                List list = config.getKeyExchangeExtensions();
                if (list != null) {
                    for (ExtensionAlgorithm algorithm : list) {
                        String name = algorithm.getAlgorithmName();
                        if (kexs.containsKey(name)) {
                            log.debug((Object)("Standard key exchange " + name + " is being overidden by " + algorithm.getImplementationClass()));
                        } else {
                            log.debug((Object)(String.valueOf(algorithm.getAlgorithmName()) + " key exchange is implemented by " + algorithm.getImplementationClass()));
                        }
                        try {
                            kexs.put(algorithm.getAlgorithmName(), ConfigurationLoader.getExtensionClass(algorithm.getImplementationClass()));
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error((Object)("Could not locate " + algorithm.getImplementationClass()));
                        }
                    }
                }
                defaultAlgorithm = config.getDefaultKeyExchange();
            }
        }
        catch (ConfigurationException configurationException) {}
        if (defaultAlgorithm == null || !kexs.containsKey(defaultAlgorithm)) {
            log.debug((Object)"The default key exchange is not set! using first in list");
            Iterator it = kexs.keySet().iterator();
            defaultAlgorithm = (String)it.next();
        }
    }

    protected SshKeyExchangeFactory() {
    }

    public static void initialize() {
    }

    public static String getDefaultKeyExchange() {
        return defaultAlgorithm;
    }

    public static List getSupportedKeyExchanges() {
        return new ArrayList(kexs.keySet());
    }

    public static SshKeyExchange newInstance(String methodName) throws AlgorithmNotSupportedException {
        try {
            return (SshKeyExchange)((Class)kexs.get(methodName)).newInstance();
        }
        catch (Exception exception) {
            throw new AlgorithmNotSupportedException(String.valueOf(methodName) + " is not supported!");
        }
    }
}

