/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.submitter.Assignment;
import edu.stanford.cs106.submitter.SubmitterWizard;
import java.util.List;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AssignmentSelectPage
extends WizardPage
implements IPageChangedListener {
    private Composite composite;
    private Text directory;
    private org.eclipse.swt.widgets.List assignmentList;
    private List<Assignment> assignments;

    public Assignment getSelectedAssignment() {
        String[] assignmentSelections = this.assignmentList.getSelection();
        if (assignmentSelections == null || assignmentSelections.length == 0) {
            return null;
        }
        String assignment = assignmentSelections[0];
        for (Assignment possibleMatch : this.assignments) {
            if (!assignment.equals(possibleMatch.toString())) continue;
            return possibleMatch;
        }
        return null;
    }

    protected AssignmentSelectPage() {
        super("Choose assignment");
        this.setDescription("Choose the assignment that you want to submit.");
    }

    public boolean isPageComplete() {
        return this.getSelectedAssignment() != null;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, true));
        this.assignmentList = new org.eclipse.swt.widgets.List(this.composite, 2560);
        this.assignmentList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AssignmentSelectPage.this.getWizard().getContainer().updateButtons();
            }
        });
        GridData listData = new GridData(4, 4, true, true);
        this.assignmentList.setLayoutData((Object)listData);
        this.setControl((Control)this.composite);
    }

    public void initAssignmentList() {
        this.assignmentList.removeAll();
        long bestOffset = Long.MAX_VALUE;
        this.assignments = ((SubmitterWizard)this.getWizard()).getAssignments();
        for (Assignment assignment : this.assignments) {
            long offset = assignment.getDueDate().getTime() - System.currentTimeMillis();
            this.assignmentList.add(assignment.toString());
            if (offset < 0L || offset >= bestOffset) continue;
            bestOffset = offset;
            this.assignmentList.select(this.assignmentList.getItemCount() - 1);
        }
        this.getWizard().getContainer().updateButtons();
    }

    public void pageChanged(PageChangedEvent event) {
        System.out.println("Page changed");
        if (event.getSelectedPage().equals((Object)this)) {
            System.out.println("To assignment page.");
            this.initAssignmentList();
        }
    }
}

