/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManualClassSelectionDialog {
    private Shell dialogShell;
    private Text warningResponseText;
    private Combo classCombo;
    private String classSelected;
    private Button ok;
    private Button cancel;
    private boolean testing;

    public ManualClassSelectionDialog(Shell parent, List<String> classNames) {
        this.dialogShell = new Shell(parent, 66800);
        this.dialogShell.setLayout((Layout)new GridLayout(2, true));
        Text warningLabel = new Text((Composite)this.dialogShell, 842);
        warningLabel.setEnabled(false);
        warningLabel.setText("It appears that we couldn't find your section leader/class. \nIn order to sign up for CS106, you must do two things: \n1) Enroll in the lecture through Axess or through SCPD.\nAND\n2) Sign up for a section at http://cs198.stanford.edu/ \nIf you do not do both of these things, your assignments will not be graded, your Stanford career may be ruined, and you may become the star in a prime-time series about your wacky hijinks with your NSA and CIA handlers. It'll run before Heroes. That would be very sad, wouldn't it?\nIf \n1) Section assignments haven't completed yet, but you've submitted your preferences.\nOR\n2) You've sent an email to cs198@cs.stanford.edu asking the CS198 coordinators to ensure that you're in a section.\nTHEN AND ONLY THEN\nPlease show your attentive agreement by typing \n\"Yes, that would be very sad!\" below. \nPunctuation and capitalization counts!");
        GridData warningLabelGD = new GridData();
        warningLabelGD.heightHint = 400;
        warningLabelGD.widthHint = 500;
        warningLabelGD.horizontalSpan = 2;
        warningLabel.setLayoutData((Object)warningLabelGD);
        this.warningResponseText = new Text((Composite)this.dialogShell, 2052);
        this.warningResponseText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String enteredText = ManualClassSelectionDialog.this.warningResponseText.getText();
                ManualClassSelectionDialog.this.testing = enteredText.indexOf("testing") >= 0;
                boolean correct = enteredText.indexOf("Yes, that would be very sad!") >= 0 || ManualClassSelectionDialog.this.testing;
                ManualClassSelectionDialog.this.classCombo.setEnabled(correct);
                ManualClassSelectionDialog.this.ok.setEnabled(correct);
            }
        });
        GridData warningResponseGD = new GridData();
        warningResponseGD.widthHint = 500;
        warningResponseGD.horizontalSpan = 2;
        this.warningResponseText.setLayoutData((Object)warningResponseGD);
        new Label((Composite)this.dialogShell, 0).setText("Choose the class you'd like to add: ");
        this.classCombo = new Combo((Composite)this.dialogShell, 8);
        this.classCombo.setItems(classNames.toArray(new String[0]));
        this.classCombo.select(0);
        this.classCombo.setEnabled(false);
        this.cancel = new Button((Composite)this.dialogShell, 8);
        this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManualClassSelectionDialog.this.dialogShell.close();
            }
        });
        this.cancel.setText("Cancel");
        this.ok = new Button((Composite)this.dialogShell, 8);
        this.ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManualClassSelectionDialog.this.classSelected = String.valueOf(ManualClassSelectionDialog.this.classCombo.getItem(ManualClassSelectionDialog.this.classCombo.getSelectionIndex())) + ":" + (ManualClassSelectionDialog.this.testing ? "testing" : "unknown");
                ManualClassSelectionDialog.this.dialogShell.close();
            }
        });
        this.ok.setText("Ok");
        this.ok.setEnabled(false);
    }

    public String show() {
        this.dialogShell.pack();
        this.dialogShell.open();
        while (!this.dialogShell.isDisposed()) {
            if (this.dialogShell.getDisplay().readAndDispatch()) continue;
            this.dialogShell.getDisplay().sleep();
        }
        return this.classSelected;
    }
}

