/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.submitter.ISubmissionProducer;
import edu.stanford.cs106.submitter.ProjectSelectPage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class StandaloneProjectSelectPage
extends ProjectSelectPage
implements ISubmissionProducer {
    private Composite composite;
    private Text directory;
    private Table fileTable;
    public static final String[] selectedExtensions = new String[]{"cpp", "cc", "h", "java", "project"};

    public StandaloneProjectSelectPage() {
        super("Select project directory");
        this.setMessage("Choose the project directory to submit.");
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(6, true));
        new Label(this.composite, 0).setText("Project Directory:");
        this.directory = new Text(this.composite, 2048);
        this.directory.setEditable(false);
        GridData data = new GridData(768);
        data.horizontalSpan = 4;
        this.directory.setLayoutData((Object)data);
        Button button = new Button(this.composite, 8);
        button.setText("Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            private void fillOutTable(File topDir, File dir) {
                File[] fileArray = dir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    try {
                        if (file.isDirectory() && file.getCanonicalPath().equals(dir.getCanonicalPath())) {
                            System.out.println("Got symlink: " + dir.getPath());
                            return;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    if (file.isDirectory()) {
                        this.fillOutTable(topDir, file);
                    } else {
                        TableItem fileItem = new TableItem(StandaloneProjectSelectPage.this.fileTable, 0);
                        fileItem.setText(file.getAbsolutePath().substring(topDir.getAbsolutePath().length() + 1));
                        this.isFileEntryPreselected(file, fileItem);
                    }
                    ++n2;
                }
            }

            private void isFileEntryPreselected(File file, TableItem fileItem) {
                String[] stringArray = selectedExtensions;
                int n = selectedExtensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String extension = stringArray[n2];
                    if (file.getName().endsWith(extension)) {
                        fileItem.setChecked(true);
                        break;
                    }
                    ++n2;
                }
            }

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(StandaloneProjectSelectPage.this.composite.getShell());
                dlg.setFilterPath(StandaloneProjectSelectPage.this.directory.getText());
                dlg.setText("Select Project Directory");
                dlg.setMessage("Select the project directory");
                String dir = dlg.open();
                if (dir != null) {
                    StandaloneProjectSelectPage.this.directory.setText(dir);
                    File dirFile = new File(dir);
                    StandaloneProjectSelectPage.this.fileTable.removeAll();
                    this.fillOutTable(dirFile, dirFile);
                    StandaloneProjectSelectPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        this.fileTable = new Table(this.composite, 2592);
        GridData fileTableData = new GridData(4, 4, true, true);
        fileTableData.horizontalSpan = 6;
        this.fileTable.setLayoutData((Object)fileTableData);
        this.fileTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StandaloneProjectSelectPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.setControl((Control)this.composite);
    }

    public String getRoot() {
        return this.directory.getText();
    }

    public File[] getSelectedFiles() {
        ArrayList<File> ret = new ArrayList<File>();
        TableItem[] tableItemArray = this.fileTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                ret.add(new File(String.valueOf(this.getRoot()) + File.separator + item.getText()));
            }
            ++n2;
        }
        return ret.toArray(new File[0]);
    }

    public boolean isPageComplete() {
        return this.getSelectedFiles().length > 0;
    }

    public boolean getLoggingOn() {
        return false;
    }
}

