/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.submitter;

import edu.stanford.cs106.submitter.Submitter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UpdateNotifier {
    static final String CURRENT_VERSION = "2";

    public static void main(String[] args) {
        String error = "";
        String longError = "";
        try {
            URL updatePage = new URL("http://pointer.stanford.edu/cs106submitter/version");
            InputStream updateStream = updatePage.openStream();
            BufferedReader updateBR = new BufferedReader(new InputStreamReader(updateStream));
            String version = updateBR.readLine();
            if (version == null) {
                error = "Couldn't obtain version from the server. Please send an email to frew@stanford.edu about this.";
            } else if (!CURRENT_VERSION.equals(version)) {
                error = "This submitter is version 2. The current version is " + version + ". Please update me!";
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            error = e.getLocalizedMessage();
            longError = sw.toString();
        }
        if (error != "") {
            Display display = new Display();
            Shell shell = new Shell(display);
            Status status = new Status(4, "edu.stanford.submitter", 0, longError, null);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)longError, (String)error, (IStatus)status);
            shell.dispose();
            display.dispose();
        }
        Submitter.main(args);
    }
}

