/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.ui;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class MainTypeSelector
extends ElementListSelectionDialog {
    private final IType[] fTypes;
    private String argsString;
    private Text argsText;

    public MainTypeSelector(Shell shell, IType[] types) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(80));
        this.fTypes = types;
        this.setMessage("Choose a type to run");
        this.argsText = null;
        this.argsString = "";
    }

    public int open() {
        if (this.fTypes == null) {
            return 1;
        }
        String[] toAdd = new String[this.fTypes.length];
        int i = 0;
        while (i < this.fTypes.length) {
            IType iType = this.fTypes[i];
            toAdd[i] = iType.getFullyQualifiedName();
            System.out.println((Object)toAdd[i]);
            ++i;
        }
        this.setElements(this.fTypes);
        return super.open();
    }

    public void setCmdString(String cmdString) {
        this.argsString = cmdString;
    }

    public String getCmdString() {
        return this.argsString;
    }

    protected void computeResult() {
        super.computeResult();
        this.argsString = this.argsText.getText();
    }

    public Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Label label = new Label(contents, 4);
        label.setLayoutData((Object)new GridData(768));
        label.setText("Command line arguments:");
        this.argsText = new Text(contents, 2052);
        this.argsText.setLayoutData((Object)new GridData(768));
        this.argsText.setText(this.argsString);
        return contents;
    }
}

