/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.cs106.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleMainMethodSearchEngine {
    public IType[] searchMainMethods(IProgressMonitor pm) {
        pm.beginTask("Searching for main methods.", 100);
        int searchTicks = 25;
        SearchPattern pattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        MethodCollector collector = new MethodCollector();
        SubProgressMonitor searchMonitor = new SubProgressMonitor(pm, searchTicks);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        try {
            new SearchEngine().search(pattern, participants, scope, (SearchRequestor)collector, (IProgressMonitor)searchMonitor);
        }
        catch (CoreException coreException) {}
        List<IType> result = collector.getResult();
        this.addSpecificType(result, "acm.program.Program");
        this.addSpecificType(result, "stanford.karel.Karel");
        SubProgressMonitor subtypesMonitor = new SubProgressMonitor(pm, 75);
        subtypesMonitor.beginTask("Searching for classes that inherit main methods.", result.size());
        Set<IType> set = this.addSubtypes(result, (IProgressMonitor)subtypesMonitor, scope);
        set = this.filterTypes(set, "acm");
        set = this.filterTypes(set, "stanford");
        return set.toArray(new IType[set.size()]);
    }

    private Set<IType> filterTypes(Set<IType> types, String prefix) {
        HashSet<IType> filteredTypes = new HashSet<IType>();
        for (IType type : types) {
            if (type.getFullyQualifiedName().startsWith(prefix)) continue;
            filteredTypes.add(type);
        }
        return filteredTypes;
    }

    private void addSpecificType(List<IType> result, String type) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        System.out.println("Processing projects for " + type);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
                if (javaProject != null) {
                    System.out.println("Got Java project");
                    IType programType = javaProject.findType(type);
                    if (programType != null) {
                        result.add(programType);
                        System.out.println("Successfully found " + programType);
                    }
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException coreException) {}
            ++n2;
        }
    }

    private Set<IType> addSubtypes(List<IType> types, IProgressMonitor monitor, IJavaSearchScope scope) {
        Iterator<IType> iterator = types.iterator();
        HashSet<IType> result = new HashSet<IType>(types.size());
        IType type = null;
        ITypeHierarchy hierarchy = null;
        IType[] subtypes = null;
        while (iterator.hasNext()) {
            type = iterator.next();
            if (result.add(type)) {
                try {
                    hierarchy = type.newTypeHierarchy(monitor);
                    subtypes = hierarchy.getAllSubtypes(type);
                    int i = 0;
                    while (i < subtypes.length) {
                        if (scope.encloses((IJavaElement)subtypes[i])) {
                            result.add(subtypes[i]);
                        }
                        ++i;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            monitor.worked(1);
        }
        return result;
    }

    public static IPackageFragmentRoot getPackageFragmentRoot(IJavaElement element) {
        return (IPackageFragmentRoot)element.getAncestor(3);
    }

    public IType[] searchMainMethods(IRunnableContext context) throws InvocationTargetException, InterruptedException {
        final IType[][] res = new IType[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                res[0] = SimpleMainMethodSearchEngine.this.searchMainMethods(pm);
            }
        };
        context.run(true, true, runnable);
        return res[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodCollector
    extends SearchRequestor {
        private List<IType> result = new ArrayList<IType>();

        public List<IType> getResult() {
            return this.result;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (enclosingElement instanceof IMethod) {
                try {
                    IMethod curr = (IMethod)enclosingElement;
                    if (curr.isMainMethod()) {
                        IPackageFragmentRoot root = (IPackageFragmentRoot)curr.getAncestor(3);
                        if (root == null || root.isArchive()) {
                            return;
                        }
                        if (curr.isBinary()) {
                            return;
                        }
                        IType declaringType = curr.getDeclaringType();
                        this.result.add(declaringType);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }
}

