/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.treewalk.TreeWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffEntry {
    static final AbbreviatedObjectId A_ZERO = AbbreviatedObjectId.fromObjectId(ObjectId.zeroId());
    public static final String DEV_NULL = "/dev/null";
    protected String oldName;
    protected String newName;
    protected FileMode oldMode;
    protected FileMode newMode;
    protected ChangeType changeType;
    protected int score;
    protected AbbreviatedObjectId oldId;
    protected AbbreviatedObjectId newId;

    protected DiffEntry() {
    }

    public static List<DiffEntry> scan(TreeWalk walk) throws IOException {
        ArrayList<DiffEntry> r = new ArrayList<DiffEntry>();
        MutableObjectId idBuf = new MutableObjectId();
        while (walk.next()) {
            DiffEntry entry = new DiffEntry();
            walk.getObjectId(idBuf, 0);
            entry.oldId = AbbreviatedObjectId.fromObjectId(idBuf);
            walk.getObjectId(idBuf, 1);
            entry.newId = AbbreviatedObjectId.fromObjectId(idBuf);
            entry.oldMode = walk.getFileMode(0);
            entry.newMode = walk.getFileMode(1);
            entry.newName = entry.oldName = walk.getPathString();
            if (entry.oldMode == FileMode.MISSING) {
                entry.oldName = DEV_NULL;
                entry.changeType = ChangeType.ADD;
                r.add(entry);
                continue;
            }
            if (entry.newMode == FileMode.MISSING) {
                entry.newName = DEV_NULL;
                entry.changeType = ChangeType.DELETE;
                r.add(entry);
                continue;
            }
            entry.changeType = ChangeType.MODIFY;
            if (RenameDetector.sameType(entry.oldMode, entry.newMode)) {
                r.add(entry);
                continue;
            }
            r.addAll(DiffEntry.breakModify(entry));
        }
        return r;
    }

    static DiffEntry add(String path, AnyObjectId id) {
        DiffEntry e = new DiffEntry();
        e.oldId = A_ZERO;
        e.oldMode = FileMode.MISSING;
        e.oldName = DEV_NULL;
        e.newId = AbbreviatedObjectId.fromObjectId(id);
        e.newMode = FileMode.REGULAR_FILE;
        e.newName = path;
        e.changeType = ChangeType.ADD;
        return e;
    }

    static DiffEntry delete(String path, AnyObjectId id) {
        DiffEntry e = new DiffEntry();
        e.oldId = AbbreviatedObjectId.fromObjectId(id);
        e.oldMode = FileMode.REGULAR_FILE;
        e.oldName = path;
        e.newId = A_ZERO;
        e.newMode = FileMode.MISSING;
        e.newName = DEV_NULL;
        e.changeType = ChangeType.DELETE;
        return e;
    }

    static DiffEntry modify(String path) {
        DiffEntry e = new DiffEntry();
        e.oldMode = FileMode.REGULAR_FILE;
        e.oldName = path;
        e.newMode = FileMode.REGULAR_FILE;
        e.newName = path;
        e.changeType = ChangeType.MODIFY;
        return e;
    }

    static List<DiffEntry> breakModify(DiffEntry entry) {
        DiffEntry del = new DiffEntry();
        del.oldId = entry.getOldId();
        del.oldMode = entry.getOldMode();
        del.oldName = entry.getOldName();
        del.newId = A_ZERO;
        del.newMode = FileMode.MISSING;
        del.newName = DEV_NULL;
        del.changeType = ChangeType.DELETE;
        DiffEntry add = new DiffEntry();
        add.oldId = A_ZERO;
        add.oldMode = FileMode.MISSING;
        add.oldName = DEV_NULL;
        add.newId = entry.getNewId();
        add.newMode = entry.getNewMode();
        add.newName = entry.getNewName();
        add.changeType = ChangeType.ADD;
        return Arrays.asList(del, add);
    }

    static DiffEntry pair(ChangeType changeType, DiffEntry src, DiffEntry dst, int score) {
        DiffEntry r = new DiffEntry();
        r.oldId = src.oldId;
        r.oldMode = src.oldMode;
        r.oldName = src.oldName;
        r.newId = dst.newId;
        r.newMode = dst.newMode;
        r.newName = dst.newName;
        r.changeType = changeType;
        r.score = score;
        return r;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public FileMode getOldMode() {
        return this.oldMode;
    }

    public FileMode getNewMode() {
        return this.newMode;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public int getScore() {
        return this.score;
    }

    public AbbreviatedObjectId getOldId() {
        return this.oldId;
    }

    public AbbreviatedObjectId getNewId() {
        return this.newId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DiffEntry[");
        buf.append((Object)this.changeType);
        buf.append(" ");
        switch (this.changeType) {
            case ADD: {
                buf.append(this.newName);
                break;
            }
            case COPY: {
                buf.append(String.valueOf(this.oldName) + "->" + this.newName);
                break;
            }
            case DELETE: {
                buf.append(this.oldName);
                break;
            }
            case MODIFY: {
                buf.append(this.oldName);
                break;
            }
            case RENAME: {
                buf.append(String.valueOf(this.oldName) + "->" + this.newName);
            }
        }
        buf.append("]");
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ChangeType {
        ADD,
        MODIFY,
        DELETE,
        RENAME,
        COPY;

    }
}

