/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.util.RawCharUtil;

public class RawTextIgnoreAllWhitespace
extends RawText {
    public static final RawText.Factory FACTORY = new RawText.Factory(){

        public RawText create(byte[] input) {
            return new RawTextIgnoreAllWhitespace(input);
        }
    };

    public RawTextIgnoreAllWhitespace(byte[] input) {
        super(input);
    }

    public boolean equals(int i, Sequence other, int j) {
        return RawTextIgnoreAllWhitespace.equals(this, i + 1, (RawText)other, j + 1);
    }

    private static boolean equals(RawText a, int ai, RawText b, int bi) {
        if (a.hashes.get(ai) != b.hashes.get(bi)) {
            return false;
        }
        int as = a.lines.get(ai);
        int bs = b.lines.get(bi);
        int ae = a.lines.get(ai + 1);
        int be = b.lines.get(bi + 1);
        ae = RawCharUtil.trimTrailingWhitespace(a.content, as, ae);
        be = RawCharUtil.trimTrailingWhitespace(b.content, bs, be);
        while (as < ae && bs < be) {
            byte ac = a.content[as];
            byte bc = b.content[bs];
            while (as < ae - 1 && RawCharUtil.isWhitespace(ac)) {
                ac = a.content[++as];
            }
            while (bs < be - 1 && RawCharUtil.isWhitespace(bc)) {
                bc = b.content[++bs];
            }
            if (ac != bc) {
                return false;
            }
            ++as;
            ++bs;
        }
        return as == ae && bs == be;
    }

    protected int hashLine(byte[] raw, int ptr, int end) {
        int hash = 5381;
        while (ptr < end) {
            byte c = raw[ptr];
            if (!RawCharUtil.isWhitespace(c)) {
                hash = hash << 5 ^ c & 0xFF;
            }
            ++ptr;
        }
        return hash;
    }
}

