/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.diff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.diff.SimilarityIndex;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimilarityRenameDetector {
    private static final int BITS_PER_INDEX = 28;
    private static final int INDEX_MASK = 0xFFFFFFF;
    private static final int SCORE_SHIFT = 56;
    private ObjectReader reader;
    private List<DiffEntry> srcs;
    private List<DiffEntry> dsts;
    private long[] matrix;
    private int renameScore = 60;
    private List<DiffEntry> out;

    SimilarityRenameDetector(ObjectReader reader, List<DiffEntry> srcs, List<DiffEntry> dsts) {
        this.reader = reader;
        this.srcs = srcs;
        this.dsts = dsts;
    }

    void setRenameScore(int score) {
        this.renameScore = score;
    }

    void compute(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        pm.beginTask(JGitText.get().renamesFindingByContent, 2 * this.srcs.size() * this.dsts.size());
        int mNext = this.buildMatrix(pm);
        this.out = new ArrayList<DiffEntry>(Math.min(mNext, this.dsts.size()));
        --mNext;
        while (mNext >= 0) {
            long ent = this.matrix[mNext];
            int sIdx = SimilarityRenameDetector.srcFile(ent);
            int dIdx = SimilarityRenameDetector.dstFile(ent);
            DiffEntry s = this.srcs.get(sIdx);
            DiffEntry d = this.dsts.get(dIdx);
            if (d == null) {
                pm.update(1);
            } else {
                DiffEntry.ChangeType type;
                if (s.changeType == DiffEntry.ChangeType.DELETE) {
                    s.changeType = DiffEntry.ChangeType.RENAME;
                    type = DiffEntry.ChangeType.RENAME;
                } else {
                    type = DiffEntry.ChangeType.COPY;
                }
                this.out.add(DiffEntry.pair(type, s, d, SimilarityRenameDetector.score(ent)));
                this.dsts.set(dIdx, null);
                pm.update(1);
            }
            --mNext;
        }
        this.srcs = SimilarityRenameDetector.compactSrcList(this.srcs);
        this.dsts = SimilarityRenameDetector.compactDstList(this.dsts);
        pm.endTask();
    }

    List<DiffEntry> getMatches() {
        return this.out;
    }

    List<DiffEntry> getLeftOverSources() {
        return this.srcs;
    }

    List<DiffEntry> getLeftOverDestinations() {
        return this.dsts;
    }

    private static List<DiffEntry> compactSrcList(List<DiffEntry> in) {
        ArrayList<DiffEntry> r = new ArrayList<DiffEntry>(in.size());
        for (DiffEntry e : in) {
            if (e.changeType != DiffEntry.ChangeType.DELETE) continue;
            r.add(e);
        }
        return r;
    }

    private static List<DiffEntry> compactDstList(List<DiffEntry> in) {
        ArrayList<DiffEntry> r = new ArrayList<DiffEntry>(in.size());
        for (DiffEntry e : in) {
            if (e == null) continue;
            r.add(e);
        }
        return r;
    }

    private int buildMatrix(ProgressMonitor pm) throws IOException {
        this.matrix = new long[this.srcs.size() * this.dsts.size()];
        long[] srcSizes = new long[this.srcs.size()];
        long[] dstSizes = new long[this.dsts.size()];
        Arrays.fill(srcSizes, -1L);
        Arrays.fill(dstSizes, -1L);
        int mNext = 0;
        int srcIdx = 0;
        while (srcIdx < this.srcs.size()) {
            DiffEntry srcEnt = this.srcs.get(srcIdx);
            if (!SimilarityRenameDetector.isFile(srcEnt.oldMode)) {
                pm.update(this.dsts.size());
            } else {
                SimilarityIndex s = this.hash(srcEnt.oldId.toObjectId());
                int dstIdx = 0;
                while (dstIdx < this.dsts.size()) {
                    DiffEntry dstEnt = this.dsts.get(dstIdx);
                    if (!SimilarityRenameDetector.isFile(dstEnt.newMode)) {
                        pm.update(1);
                    } else if (!RenameDetector.sameType(srcEnt.oldMode, dstEnt.newMode)) {
                        pm.update(1);
                    } else {
                        long dstSize;
                        long srcSize = srcSizes[srcIdx];
                        if (srcSize < 0L) {
                            srcSizes[srcIdx] = srcSize = this.size(srcEnt.oldId.toObjectId());
                        }
                        if ((dstSize = dstSizes[dstIdx]) < 0L) {
                            dstSizes[dstIdx] = dstSize = this.size(dstEnt.newId.toObjectId());
                        }
                        long max = Math.max(srcSize, dstSize);
                        long min = Math.min(srcSize, dstSize);
                        if (min * 100L / max < (long)this.renameScore) {
                            pm.update(1);
                        } else {
                            int nameScore;
                            SimilarityIndex d = this.hash(dstEnt.newId.toObjectId());
                            int contentScore = s.score(d, 10000);
                            int score = (contentScore * 99 + (nameScore = SimilarityRenameDetector.nameScore(srcEnt.oldName, dstEnt.newName) * 100) * 1) / 10000;
                            if (score < this.renameScore) {
                                pm.update(1);
                            } else {
                                this.matrix[mNext++] = SimilarityRenameDetector.encode(score, srcIdx, dstIdx);
                                pm.update(1);
                            }
                        }
                    }
                    ++dstIdx;
                }
            }
            ++srcIdx;
        }
        Arrays.sort(this.matrix, 0, mNext);
        return mNext;
    }

    static int nameScore(String a, String b) {
        int dirScoreRtl;
        int dirScoreLtr;
        int aDirLen = a.lastIndexOf("/") + 1;
        int bDirLen = b.lastIndexOf("/") + 1;
        int dirMin = Math.min(aDirLen, bDirLen);
        int dirMax = Math.max(aDirLen, bDirLen);
        if (dirMax == 0) {
            dirScoreLtr = 100;
            dirScoreRtl = 100;
        } else {
            int dirSim = 0;
            while (dirSim < dirMin) {
                if (a.charAt(dirSim) != b.charAt(dirSim)) break;
                ++dirSim;
            }
            dirScoreLtr = dirSim * 100 / dirMax;
            if (dirScoreLtr == 100) {
                dirScoreRtl = 100;
            } else {
                dirSim = 0;
                while (dirSim < dirMin) {
                    if (a.charAt(aDirLen - 1 - dirSim) != b.charAt(bDirLen - 1 - dirSim)) break;
                    ++dirSim;
                }
                dirScoreRtl = dirSim * 100 / dirMax;
            }
        }
        int fileMin = Math.min(a.length() - aDirLen, b.length() - bDirLen);
        int fileMax = Math.max(a.length() - aDirLen, b.length() - bDirLen);
        int fileSim = 0;
        while (fileSim < fileMin) {
            if (a.charAt(a.length() - 1 - fileSim) != b.charAt(b.length() - 1 - fileSim)) break;
            ++fileSim;
        }
        int fileScore = fileSim * 100 / fileMax;
        return ((dirScoreLtr + dirScoreRtl) * 25 + fileScore * 50) / 100;
    }

    private SimilarityIndex hash(ObjectId objectId) throws IOException {
        SimilarityIndex r = new SimilarityIndex();
        r.hash(this.reader.open(objectId));
        r.sort();
        return r;
    }

    private long size(ObjectId objectId) throws IOException {
        return this.reader.getObjectSize(objectId, 3);
    }

    private static int score(long value) {
        return (int)(value >>> 56);
    }

    static int srcFile(long value) {
        return SimilarityRenameDetector.decodeFile((int)(value >>> 28) & 0xFFFFFFF);
    }

    static int dstFile(long value) {
        return SimilarityRenameDetector.decodeFile((int)value & 0xFFFFFFF);
    }

    static long encode(int score, int srcIdx, int dstIdx) {
        return (long)score << 56 | SimilarityRenameDetector.encodeFile(srcIdx) << 28 | SimilarityRenameDetector.encodeFile(dstIdx);
    }

    private static long encodeFile(int idx) {
        return 0xFFFFFFF - idx;
    }

    private static int decodeFile(int v) {
        return 0xFFFFFFF - v;
    }

    private static boolean isFile(FileMode mode) {
        return (mode.getBits() & 0xF000) == 32768;
    }
}

