/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore;

import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;

public class IgnoreRule {
    private String pattern;
    private boolean negation;
    private boolean nameOnly;
    private boolean dirOnly;
    private FileNameMatcher matcher;

    public IgnoreRule(String pattern) {
        this.pattern = pattern;
        this.negation = false;
        this.nameOnly = false;
        this.dirOnly = false;
        this.matcher = null;
        this.setup();
    }

    private void setup() {
        int startIndex = 0;
        int endIndex = this.pattern.length();
        if (this.pattern.startsWith("!")) {
            ++startIndex;
            this.negation = true;
        }
        if (this.pattern.endsWith("/")) {
            --endIndex;
            this.dirOnly = true;
        }
        boolean hasSlash = this.pattern.contains("/");
        this.pattern = this.pattern.substring(startIndex, endIndex);
        if (!hasSlash) {
            this.nameOnly = true;
        } else if (!this.pattern.startsWith("/")) {
            this.pattern = "/" + this.pattern;
        }
        if (this.pattern.contains("*") || this.pattern.contains("?") || this.pattern.contains("[")) {
            try {
                this.matcher = new FileNameMatcher(this.pattern, new Character('/'));
            }
            catch (InvalidPatternException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean getNameOnly() {
        return this.nameOnly;
    }

    public boolean dirOnly() {
        return this.dirOnly;
    }

    public boolean getNegation() {
        return this.negation;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isMatch(String target, boolean isDirectory) {
        block14: {
            block13: {
                if (!target.startsWith("/")) {
                    target = "/" + target;
                }
                if (this.matcher != null) break block13;
                if (target.equals(this.pattern)) {
                    return !this.dirOnly || isDirectory;
                }
                if (target.startsWith(String.valueOf(this.pattern) + "/")) {
                    return true;
                }
                if (!this.nameOnly) break block14;
                String[] stringArray = target.split("/");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String folderName = stringArray[n2];
                    if (folderName.equals(this.pattern)) {
                        return true;
                    }
                    ++n2;
                }
                break block14;
            }
            this.matcher.append(target);
            if (this.matcher.isMatch()) {
                return true;
            }
            if (this.nameOnly) {
                String[] stringArray = target.split("/");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String folderName = stringArray[n3];
                    this.matcher.reset();
                    this.matcher.append(folderName);
                    if (this.matcher.isMatch()) {
                        return true;
                    }
                    ++n3;
                }
            } else {
                this.matcher.reset();
                String[] stringArray = target.split("/");
                int n = stringArray.length;
                int n4 = 0;
                while (n4 < n) {
                    String folderName = stringArray[n4];
                    if (folderName.length() > 0) {
                        this.matcher.append("/" + folderName);
                    }
                    if (this.matcher.isMatch()) {
                        return true;
                    }
                    ++n4;
                }
            }
        }
        return false;
    }

    public boolean getResult() {
        return !this.negation;
    }
}

