/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectStream;

public abstract class ObjectLoader {
    public static final int STREAM_THRESHOLD = 0x100000;

    public abstract int getType();

    public abstract long getSize();

    public boolean isLarge() {
        try {
            this.getCachedBytes();
            return false;
        }
        catch (LargeObjectException largeObjectException) {
            return true;
        }
    }

    public final byte[] getBytes() throws LargeObjectException {
        byte[] data = this.getCachedBytes();
        byte[] copy = new byte[data.length];
        System.arraycopy(data, 0, copy, 0, data.length);
        return copy;
    }

    public abstract byte[] getCachedBytes() throws LargeObjectException;

    public abstract ObjectStream openStream() throws MissingObjectException, IOException;

    public void copyTo(OutputStream out) throws MissingObjectException, IOException {
        block6: {
            if (this.isLarge()) {
                ObjectStream in = this.openStream();
                try {
                    int n;
                    byte[] tmp = new byte[1024];
                    long copied = 0L;
                    while ((n = in.read(tmp)) >= 0) {
                        out.write(tmp, 0, n);
                        copied += (long)n;
                    }
                    if (copied != this.getSize()) {
                        throw new EOFException();
                    }
                    break block6;
                }
                finally {
                    in.close();
                }
            }
            out.write(this.getCachedBytes());
        }
    }

    public static class SmallObject
    extends ObjectLoader {
        private final int type;
        private final byte[] data;

        public SmallObject(int type, byte[] data) {
            this.type = type;
            this.data = data;
        }

        public int getType() {
            return this.type;
        }

        public long getSize() {
            return this.getCachedBytes().length;
        }

        public boolean isLarge() {
            return false;
        }

        public byte[] getCachedBytes() {
            return this.data;
        }

        public ObjectStream openStream() {
            return new ObjectStream.SmallStream(this);
        }
    }
}

