/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.lib.ProgressMonitor;

public class ThreadSafeProgressMonitor
implements ProgressMonitor {
    private final ProgressMonitor pm;
    private final ReentrantLock lock;

    public ThreadSafeProgressMonitor(ProgressMonitor pm) {
        this.pm = pm;
        this.lock = new ReentrantLock();
    }

    public void start(int totalTasks) {
        this.lock.lock();
        try {
            this.pm.start(totalTasks);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void beginTask(String title, int totalWork) {
        this.lock.lock();
        try {
            this.pm.beginTask(title, totalWork);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void update(int completed) {
        this.lock.lock();
        try {
            this.pm.update(completed);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isCancelled() {
        this.lock.lock();
        try {
            boolean bl = this.pm.isCancelled();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void endTask() {
        this.lock.lock();
        try {
            this.pm.endTask();
        }
        finally {
            this.lock.unlock();
        }
    }
}

