/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.util.SystemReader;

public class UserConfig {
    public static final Config.SectionParser<UserConfig> KEY = new Config.SectionParser<UserConfig>(){

        @Override
        public UserConfig parse(Config cfg) {
            return new UserConfig(cfg, null);
        }
    };
    private final String authorName;
    private final String authorEmail;
    private final String committerName;
    private final String committerEmail;

    private UserConfig(Config rc) {
        this.authorName = UserConfig.getNameInternal(rc, "GIT_AUTHOR_NAME");
        this.authorEmail = UserConfig.getEmailInternal(rc, "GIT_AUTHOR_EMAIL");
        this.committerName = UserConfig.getNameInternal(rc, "GIT_COMMITTER_NAME");
        this.committerEmail = UserConfig.getEmailInternal(rc, "GIT_COMMITTER_EMAIL");
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getCommitterName() {
        return this.committerName;
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public String getCommitterEmail() {
        return this.committerEmail;
    }

    private static String getNameInternal(Config rc, String envKey) {
        String username = rc.getString("user", null, "name");
        if (username == null) {
            username = UserConfig.system().getenv(envKey);
        }
        if (username == null) {
            username = UserConfig.system().getProperty("user.name");
        }
        if (username == null) {
            username = "unknown-user";
        }
        return username;
    }

    private static String getEmailInternal(Config rc, String envKey) {
        String email = rc.getString("user", null, "email");
        if (email == null) {
            email = UserConfig.system().getenv(envKey);
        }
        if (email == null) {
            String username = UserConfig.system().getProperty("user.name");
            if (username == null) {
                username = "unknown-user";
            }
            email = String.valueOf(username) + "@" + UserConfig.system().getHostname();
        }
        return email;
    }

    private static SystemReader system() {
        return SystemReader.getInstance();
    }

    /* synthetic */ UserConfig(Config config, UserConfig userConfig) {
        this(config);
    }
}

