/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jgit.diff.Edit;
import org.eclipse.jgit.diff.EditList;
import org.eclipse.jgit.diff.MyersDiff;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.merge.MergeChunk;
import org.eclipse.jgit.merge.MergeResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MergeAlgorithm {
    private static final Edit END_EDIT = new Edit(Integer.MAX_VALUE, Integer.MAX_VALUE);

    private MergeAlgorithm() {
    }

    public static MergeResult merge(Sequence base, Sequence ours, Sequence theirs) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>(3);
        sequences.add(base);
        sequences.add(ours);
        sequences.add(theirs);
        MergeResult result = new MergeResult(sequences);
        EditList oursEdits = new MyersDiff(base, ours).getEdits();
        Iterator<Edit> baseToOurs = oursEdits.iterator();
        EditList theirsEdits = new MyersDiff(base, theirs).getEdits();
        Iterator<Edit> baseToTheirs = theirsEdits.iterator();
        int current = 0;
        Edit oursEdit = MergeAlgorithm.nextEdit(baseToOurs);
        Edit theirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
        while (theirsEdit != END_EDIT || oursEdit != END_EDIT) {
            if (oursEdit.getEndA() <= theirsEdit.getBeginA()) {
                if (current != oursEdit.getBeginA()) {
                    result.add(0, current, oursEdit.getBeginA(), MergeChunk.ConflictState.NO_CONFLICT);
                }
                result.add(1, oursEdit.getBeginB(), oursEdit.getEndB(), MergeChunk.ConflictState.NO_CONFLICT);
                current = oursEdit.getEndA();
                oursEdit = MergeAlgorithm.nextEdit(baseToOurs);
                continue;
            }
            if (theirsEdit.getEndA() <= oursEdit.getBeginA()) {
                if (current != theirsEdit.getBeginA()) {
                    result.add(0, current, theirsEdit.getBeginA(), MergeChunk.ConflictState.NO_CONFLICT);
                }
                result.add(2, theirsEdit.getBeginB(), theirsEdit.getEndB(), MergeChunk.ConflictState.NO_CONFLICT);
                current = theirsEdit.getEndA();
                theirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
                continue;
            }
            if (oursEdit.getBeginA() != current && theirsEdit.getBeginA() != current) {
                result.add(0, current, Math.min(oursEdit.getBeginA(), theirsEdit.getBeginA()), MergeChunk.ConflictState.NO_CONFLICT);
            }
            int oursBeginB = oursEdit.getBeginB();
            int theirsBeginB = theirsEdit.getBeginB();
            if (oursEdit.getBeginA() < theirsEdit.getBeginA()) {
                theirsBeginB -= theirsEdit.getBeginA() - oursEdit.getBeginA();
            } else {
                oursBeginB -= oursEdit.getBeginA() - theirsEdit.getBeginA();
            }
            Edit nextOursEdit = MergeAlgorithm.nextEdit(baseToOurs);
            Edit nextTheirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
            while (true) {
                if (oursEdit.getEndA() > nextTheirsEdit.getBeginA()) {
                    theirsEdit = nextTheirsEdit;
                    nextTheirsEdit = MergeAlgorithm.nextEdit(baseToTheirs);
                    continue;
                }
                if (theirsEdit.getEndA() <= nextOursEdit.getBeginA()) break;
                oursEdit = nextOursEdit;
                nextOursEdit = MergeAlgorithm.nextEdit(baseToOurs);
            }
            int oursEndB = oursEdit.getEndB();
            int theirsEndB = theirsEdit.getEndB();
            if (oursEdit.getEndA() < theirsEdit.getEndA()) {
                oursEndB += theirsEdit.getEndA() - oursEdit.getEndA();
            } else {
                theirsEndB += oursEdit.getEndA() - theirsEdit.getEndA();
            }
            result.add(1, oursBeginB, oursEndB, MergeChunk.ConflictState.FIRST_CONFLICTING_RANGE);
            result.add(2, theirsBeginB, theirsEndB, MergeChunk.ConflictState.NEXT_CONFLICTING_RANGE);
            current = Math.max(oursEdit.getEndA(), theirsEdit.getEndA());
            oursEdit = nextOursEdit;
            theirsEdit = nextTheirsEdit;
        }
        if (current < base.size()) {
            result.add(0, current, base.size(), MergeChunk.ConflictState.NO_CONFLICT);
        }
        return result;
    }

    private static Edit nextEdit(Iterator<Edit> it) {
        return it.hasNext() ? it.next() : END_EDIT;
    }
}

