/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jgit.JGitText;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileObjectDatabase;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.storage.file.ObjectDirectory;
import org.eclipse.jgit.storage.file.RefDirectory;
import org.eclipse.jgit.storage.file.ReflogReader;
import org.eclipse.jgit.util.SystemReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRepository
extends Repository {
    private final FileBasedConfig userConfig = SystemReader.getInstance().openUserConfig(this.getFS());
    private final FileBasedConfig repoConfig = new FileBasedConfig(this.userConfig, this.getFS().resolve(this.getDirectory(), "config"), this.getFS());
    private final RefDatabase refs;
    private final ObjectDirectory objectDatabase;

    public FileRepository(File gitDir) throws IOException {
        this((BaseRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(gitDir)).setup());
    }

    public FileRepository(BaseRepositoryBuilder options) throws IOException {
        super(options);
        String repositoryFormatVersion;
        this.loadUserConfig();
        this.loadRepoConfig();
        this.refs = new RefDirectory(this);
        this.objectDatabase = new ObjectDirectory(this.repoConfig, options.getObjectDirectory(), options.getAlternateObjectDirectories(), this.getFS());
        this.getListenerList().addConfigChangedListener(this.objectDatabase);
        if (this.objectDatabase.exists() && !"0".equals(repositoryFormatVersion = this.getConfig().getString("core", null, "repositoryformatversion"))) {
            throw new IOException(MessageFormat.format(JGitText.get().unknownRepositoryFormat2, repositoryFormatVersion));
        }
    }

    private void loadUserConfig() throws IOException {
        try {
            this.userConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException(MessageFormat.format(JGitText.get().userConfigFileInvalid, this.userConfig.getFile().getAbsolutePath(), e1));
            e2.initCause(e1);
            throw e2;
        }
    }

    private void loadRepoConfig() throws IOException {
        try {
            this.repoConfig.load();
        }
        catch (ConfigInvalidException e1) {
            IOException e2 = new IOException(JGitText.get().unknownRepositoryFormat);
            e2.initCause(e1);
            throw e2;
        }
    }

    @Override
    public void create(boolean bare) throws IOException {
        FileBasedConfig cfg = this.getConfig();
        if (cfg.getFile().exists()) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().repositoryAlreadyExists, this.getDirectory()));
        }
        this.getDirectory().mkdirs();
        this.refs.create();
        this.objectDatabase.create();
        new File(this.getDirectory(), "branches").mkdir();
        RefUpdate head = this.updateRef("HEAD");
        head.disableRefLog();
        head.link("refs/heads/master");
        cfg.setInt("core", null, "repositoryformatversion", 0);
        cfg.setBoolean("core", null, "filemode", true);
        if (bare) {
            cfg.setBoolean("core", null, "bare", true);
        }
        cfg.setBoolean("core", null, "logallrefupdates", !bare);
        cfg.setBoolean("core", null, "autocrlf", false);
        cfg.save();
    }

    @Override
    public File getObjectsDirectory() {
        return this.objectDatabase.getDirectory();
    }

    @Override
    public ObjectDirectory getObjectDatabase() {
        return this.objectDatabase;
    }

    @Override
    public RefDatabase getRefDatabase() {
        return this.refs;
    }

    @Override
    public FileBasedConfig getConfig() {
        if (this.userConfig.isOutdated()) {
            try {
                this.loadUserConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.repoConfig.isOutdated()) {
            try {
                this.loadRepoConfig();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.repoConfig;
    }

    @Override
    public Set<ObjectId> getAdditionalHaves() {
        HashSet<ObjectId> r = new HashSet<ObjectId>();
        FileObjectDatabase.AlternateHandle[] alternateHandleArray = this.objectDatabase.myAlternates();
        int n = alternateHandleArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileObjectDatabase.AlternateHandle d = alternateHandleArray[n2];
            if (d instanceof FileObjectDatabase.AlternateRepository) {
                FileRepository repo = ((FileObjectDatabase.AlternateRepository)d).repository;
                for (Ref ref : repo.getAllRefs().values()) {
                    r.add(ref.getObjectId());
                }
                r.addAll(((Repository)repo).getAdditionalHaves());
            }
            ++n2;
        }
        return r;
    }

    @Override
    public void openPack(File pack, File idx) throws IOException {
        this.objectDatabase.openPack(pack, idx);
    }

    @Override
    public void scanForRepoChanges() throws IOException {
        this.getAllRefs();
        if (!this.isBare()) {
            this.getIndex();
        }
    }

    @Override
    public ReflogReader getReflogReader(String refName) throws IOException {
        Ref ref = this.getRef(refName);
        if (ref != null) {
            return new ReflogReader(this, ref.getName());
        }
        return null;
    }
}

